package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosFrequencyRowModel.java 666 2013-03-23 18:20:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/frequency/BenthosFrequencyRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Represents a batch frequency row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class BenthosFrequencyRowModel extends AbstractTuttiBeanUIModel<SpeciesBatchFrequency, BenthosFrequencyRowModel> implements Comparable<BenthosFrequencyRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_LENGTH_STEP = "lengthStep";

    public static final String PROPERTY_NUMBER = "number";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";

    /**
     * Length step.
     *
     * @since 0.2
     */
    protected Float lengthStep;

    /**
     * Count of fishes for this lengthStep.
     *
     * @since 0.2
     */
    protected Integer number;

    /**
     * Weight of fishes observed.
     *
     * @since 0.2
     */
    protected Float weight;

    /**
     * Length step caracteristic.
     *
     * @since 0.3
     */
    protected Caracteristic lengthStepCaracteristic;

    protected static final Binder<SpeciesBatchFrequency, BenthosFrequencyRowModel> fromBeanBinder =
            BinderFactory.newBinder(SpeciesBatchFrequency.class,
                                    BenthosFrequencyRowModel.class);

    protected static final Binder<BenthosFrequencyRowModel, SpeciesBatchFrequency> toBeanBinder =
            BinderFactory.newBinder(BenthosFrequencyRowModel.class,
                                    SpeciesBatchFrequency.class);

    private static final Ordering<Float> ordering = Ordering.natural().nullsFirst();

    public static List<BenthosFrequencyRowModel> fromBeans(List<SpeciesBatchFrequency> frequency) {
        List<BenthosFrequencyRowModel> result = Lists.newArrayList();
        for (SpeciesBatchFrequency b : frequency) {
            BenthosFrequencyRowModel model = new BenthosFrequencyRowModel();
            fromBeanBinder.copy(b, model);
            result.add(model);
        }
        return result;
    }

    public static List<SpeciesBatchFrequency> toBeans(List<BenthosFrequencyRowModel> frequency, SpeciesBatch batch) {
        List<SpeciesBatchFrequency> result = Lists.newArrayList();
        for (BenthosFrequencyRowModel b : frequency) {
            SpeciesBatchFrequency model = new SpeciesBatchFrequency();
            toBeanBinder.copy(b, model);
            model.setBatch(batch);
            result.add(model);
        }
        return result;
    }

    public BenthosFrequencyRowModel() {
        super(SpeciesBatchFrequency.class, fromBeanBinder, toBeanBinder);
    }

    public Float getLengthStep() {
        return lengthStep;
    }

    public void setLengthStep(Float lengthStep) {
        Object oldValue = getLengthStep();
        this.lengthStep = lengthStep;
        firePropertyChange(PROPERTY_LENGTH_STEP, oldValue, lengthStep);
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        Object oldValue = getNumber();
        this.number = number;
        firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    public Float getWeight() {
        return weight;
    }

    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Object oldValue = getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
    }

    @Override
    public int compareTo(BenthosFrequencyRowModel o) {
        int result = ordering.compare(lengthStep, o.lengthStep);
        return result;
    }
}
