/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.config;

import com.google.common.base.Charsets;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfigOption;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Version;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.config.ApplicationConfigHelper;
import org.nuiton.util.config.ArgumentsParserException;

public class TuttiApplicationConfig {
    private static final Log log = LogFactory.getLog(TuttiApplicationConfig.class);
    protected final ApplicationConfig applicationConfig = new ApplicationConfig();
    protected final TuttiServiceConfig serviceConfig;
    protected final String[] optionKeyToNotSave;
    protected File configFile;

    public TuttiApplicationConfig(String file, String ... args) {
        this.applicationConfig.setEncoding(Charsets.UTF_8.name());
        Set providers = ApplicationConfigHelper.getProviders(null, null, null, (boolean)true);
        ApplicationConfigHelper.loadAllDefaultOption((ApplicationConfig)this.applicationConfig, (Set)providers);
        Set optionToSkip = ApplicationConfigHelper.getTransientOptionKeys((Set)providers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Option that won't be saved: " + optionToSkip));
        }
        this.optionKeyToNotSave = optionToSkip.toArray(new String[optionToSkip.size()]);
        this.applicationConfig.setConfigFileName(file);
        try {
            this.applicationConfig.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new TuttiTechnicalException("Could not parse configuration", (Throwable)e);
        }
        File tuttiBasedir = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.BASEDIR.getKey());
        if (tuttiBasedir == null) {
            tuttiBasedir = new File("");
        }
        if (!tuttiBasedir.isAbsolute()) {
            tuttiBasedir = new File(tuttiBasedir.getAbsolutePath());
        }
        if (tuttiBasedir.getName().equals("..")) {
            tuttiBasedir = tuttiBasedir.getParentFile().getParentFile();
        }
        if (tuttiBasedir.getName().equals(".")) {
            tuttiBasedir = tuttiBasedir.getParentFile();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Application basedir: " + tuttiBasedir));
        }
        this.applicationConfig.setOption(TuttiServiceConfigOption.BASEDIR.getKey(), tuttiBasedir.getAbsolutePath());
        this.serviceConfig = new TuttiServiceConfig(this.applicationConfig);
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public TuttiServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    protected File getConfigFile() {
        if (this.configFile == null) {
            File dir = this.getTuttiBasedir();
            if (dir == null || !dir.exists() || !this.isFullLaunchMode()) {
                dir = new File(this.applicationConfig.getUserConfigDirectory());
            }
            this.configFile = new File(dir, this.applicationConfig.getConfigFileName());
        }
        return this.configFile;
    }

    public void save() {
        File file = this.getConfigFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("Save configuration at: " + file));
        }
        try {
            this.applicationConfig.save(file, false, this.optionKeyToNotSave);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException("Could not save configuration at " + file, (Throwable)e);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean isFullLaunchMode() {
        return "full".equals(this.getTuttiLaunchMode());
    }

    public String getTuttiLaunchMode() {
        return this.applicationConfig.getOption(TuttiApplicationConfigOption.TUTTI_LAUNCH_MODE.getKey());
    }

    public File getUIConfigFile() {
        return this.applicationConfig.getOptionAsFile(TuttiApplicationConfigOption.UI_CONFIG_FILE.getKey());
    }

    public Float getDifferenceRateBetweenSortedAndTotalWeights() {
        return Float.valueOf(this.applicationConfig.getOptionAsFloat(TuttiApplicationConfigOption.TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE.getKey()));
    }

    public String getTremieCarousselVesselId() {
        return this.applicationConfig.getOption(TuttiApplicationConfigOption.TREMIE_CAROUSSEL_VESSEL_ID.getKey());
    }

    public boolean isAutoPopupNumberEditor() {
        return this.applicationConfig.getOptionAsBoolean(TuttiApplicationConfigOption.AUTO_POPUP_NUMBER_EDITOR.getKey());
    }

    public boolean isShowNumberEditorButton() {
        return this.applicationConfig.getOptionAsBoolean(TuttiApplicationConfigOption.SHOW_NUMBER_EDITOR_BUTTON.getKey());
    }

    public CoordinateEditorType getCoordinateEditorType() {
        String value = this.applicationConfig.getOption(TuttiApplicationConfigOption.COORDINATE_EDITOR_TYPE.getKey());
        return CoordinateEditorType.valueOf(value);
    }

    public String getProgramId() {
        String result = this.applicationConfig.getOption(TuttiApplicationConfigOption.PROGRAM_ID.getKey());
        return StringUtils.isBlank((CharSequence)result) ? null : result;
    }

    public String getCruiseId() {
        String result = this.applicationConfig.getOption(TuttiApplicationConfigOption.CRUISE_ID.getKey());
        return StringUtils.isBlank((CharSequence)result) ? null : result;
    }

    public String getProtocolId() {
        String result = this.applicationConfig.getOption(TuttiApplicationConfigOption.PROTOCOL_ID.getKey());
        return StringUtils.isBlank((CharSequence)result) ? null : result;
    }

    public List<Integer> getSamplingOrderIds() {
        ApplicationConfig.OptionList result = this.applicationConfig.getOptionAsList(TuttiApplicationConfigOption.SAMPLING_CATEGORY_ORDER_IDS.getKey());
        return result.getOptionAsInt();
    }

    public Color getColorRowInvalid() {
        return this.applicationConfig.getOptionAsColor(TuttiApplicationConfigOption.COLOR_ROW_INVALID.getKey());
    }

    public Color getColorRowReadOnly() {
        return this.applicationConfig.getOptionAsColor(TuttiApplicationConfigOption.COLOR_ROW_READ_ONLY.getKey());
    }

    public Color getColorCellWithValue() {
        return this.applicationConfig.getOptionAsColor(TuttiApplicationConfigOption.COLOR_CELL_WITH_VALUE.getKey());
    }

    public Color getColorRowToConfirm() {
        return this.applicationConfig.getOptionAsColor(TuttiApplicationConfigOption.COLOR_ROW_TO_CONFIRM.getKey());
    }

    public Color getColorComputedWeights() {
        return this.applicationConfig.getOptionAsColor(TuttiApplicationConfigOption.COLOR_COMPUTED_WEIGHTS.getKey());
    }

    public Color getColorBlockingLayer() {
        return this.applicationConfig.getOptionAsColor(TuttiApplicationConfigOption.COLOR_BLOCKING_LAYER.getKey());
    }

    public KeyStroke getShortcutClosePopup() {
        return this.applicationConfig.getOptionAsKeyStroke(TuttiApplicationConfigOption.SHORTCUT_CLOSE_POPUP.getKey());
    }

    public KeyStroke getShortCut(String actionName) {
        KeyStroke result = this.applicationConfig.getOptionAsKeyStroke("tutti.ui." + actionName);
        return result;
    }

    public String getDateFormat() {
        return this.applicationConfig.getOption(TuttiApplicationConfigOption.DATE_FORMAT.getKey());
    }

    public Version getVersion() {
        return this.serviceConfig.getVersion();
    }

    public int getInceptionYear() {
        return this.serviceConfig.getInceptionYear();
    }

    public URL getSiteUrl() {
        return this.serviceConfig.getSiteUrl();
    }

    public String getOrganizationName() {
        return this.serviceConfig.getOrganizationName();
    }

    public File getTmpDirectory() {
        return this.serviceConfig.getTmpDirectory();
    }

    public File getNewTmpDirectory(String name) {
        return new File(this.getTmpDirectory(), name + "_" + System.nanoTime());
    }

    public File getDataDirectory() {
        return this.serviceConfig.getDataDirectory();
    }

    public File getI18nDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiApplicationConfigOption.TUTTI_I18N_DIRECTORY.getKey());
    }

    public Locale getI18nLocale() {
        return this.applicationConfig.getOptionAsLocale(TuttiApplicationConfigOption.TUTTI_I18N_LOCALE.getKey());
    }

    public void setI18nLocale(Locale locale) {
        this.applicationConfig.setOption(TuttiApplicationConfigOption.TUTTI_I18N_LOCALE.getKey(), locale.toString());
    }

    public File getHelpDirectory() {
        return this.applicationConfig.getOptionAsFile(TuttiApplicationConfigOption.TUTTI_HELP_DIRECTORY.getKey());
    }

    public File getHelpDirectoryWithLocale() {
        File result = this.getHelpDirectory();
        return new File(result, this.getI18nLocale().getLanguage());
    }

    public void setProgramId(String programId) {
        if (programId == null) {
            programId = "";
        }
        this.applicationConfig.setOption(TuttiApplicationConfigOption.PROGRAM_ID.getKey(), programId);
    }

    public void setCruiseId(String cruiseId) {
        if (cruiseId == null) {
            cruiseId = "";
        }
        this.applicationConfig.setOption(TuttiApplicationConfigOption.CRUISE_ID.getKey(), cruiseId);
    }

    public void setProtocolId(String protocolId) {
        if (protocolId == null) {
            protocolId = "";
        }
        this.applicationConfig.setOption(TuttiApplicationConfigOption.PROTOCOL_ID.getKey(), protocolId);
    }

    public File getTuttiBasedir() {
        return this.serviceConfig.getBasedir();
    }

    public String getUpdateUrl() {
        return this.applicationConfig.getOption(TuttiApplicationConfigOption.TUTTI_UPDATE_URL.getKey());
    }
}

