package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FishingOperationsUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<FishingOperationsUIModel, FishingOperationsUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCHES_TAB_ENABLED = "catchesTab.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWz28bRRSeOHF+GtI2akiggJNClYho0kT8SBVKG7t24ypJq8SVKnIos95xPO16Zpkdxw5WEH8CfwBIcOeCxI0T4sCZA5eKfwEhDlwRb2bXa6+9jlMqIsVxZt773nvfvPnefPcHSnoSLTwhjQaWNa5YleJ7W48e3bee0JK6Q72SZK4SEvk/QwmUOERTdrjuKXT1cEe7rwbuq1lRdQWnvMN7cwdNeurEoV6FUqXQ61GPkuetHoTbmw23JluoYVJxqN/89WfiS/uLbxMINVzIbhpKSQ/yalcysoMSzFboEkQ6JqsO4UeQhmT8CPJ9Sa9lHeJ5e6RKP0Wfo7EdNOoSCWAKLZ6/ZINh/BuuQvNl5lUgwn2XSqKY4F5RuA8Ip45Ct8oSs7KkVSqxqinFcI1hrw7WuCS4AngsWm44343zsOC6Js6oQmMVwm2HSoXyL4i57QO1oZNVYetk77wg8K6GacOOWlI81Qkv98ct6n+3wStjbNvO4yrkcC5y/IEfsRxzghOhx1z3McAJWiIjGgq9E4NAbQZHii1KOM7AR8tao10OQec5rXdXmoGcgQ40o9upEcDd81ej3hfqRHLYzYI5YVxzcSniZCqM+qQCnx1i6eKj9mZRG77R7gtFLA2j0CsRU2DIorbeidL0ajdNYJj1T1ehzPN0QA4Y7ObmYUGHeSuMdrFEVKlCvc4gW88TJPA3wbL+9+4YU1wUJWGqVevVaMEzMQUDDfFNVeBl0W7CyXb2emUNdiR6LeIJOofbOtcWoqFDlJQ1WIbGPOyVxn3Y8kVxrksUNaDZ/Wd25rcff/8h31LCFMS+HGvaIeSgUK7U7CmmQ0/7MlhTzFndJe7mIZrwqANTwKj8lZjEDoJtSA7iXdTuWLvjbeJVACI59uynn2c/+XUYJfJo0hHEzhNtX0ATqiKBBeHYDffWbZNRqj4Onxfgd1ihEX3VoF+bRm1OgV22tsEfSFpmcEWn/U4Ikj/BCjKtiPo+9fRwGVGyRhvA1pUYtsKUrYlf/p45+P52i7EhqGC+r3mbteTHaJRxBy6omR7BYIidFlOuR2u2aA+AuJGAYCjMak3JM0dB04FUtdQl6K0b5vPm/0STxs6Z+vW3uzqdVKfEDUhiCCbC4wposkLp5qIfsGfEYW2weNob7Kx56A6InIRqoZvApaCVAA0TG2Z56rHJYctsKLTQ3OvVZH8Tl/QpAGcpzdkup1XBWUmhzX5F+MFwjMjjaug9pYRwiswt0gZw/P5/wFLwfAg53ezP6RkQZ9Ddd0QNohu6LeXLAbULilYVetvvOnxE1UGw0Q29tAz8jrcaENTN62PYrviD/hWXGXXsnvUzqu075QcVm4A7dcw8BpcROGsu+IUyzwyVHNeX1Da1TVqk9PRIihqH3ltsArtpo4KkruDt6Qi5tP7ueyvp9bWNlfTGxnJslj2D/xxHMaJMf13vR5WGxIwfE4fZ2NJZ4+DdFrkzY0Fo/f4S0tZvjvWwiNbrwN/BuaqrTjLm+xKUtHZ9JW3+xBcVeZkMKghEZIz6rCp09zxtlV64meY1x0lfu5buczhxWXXM6HO0wExFSPaZPhVny2FHvGpeJNNN/2WFs7m9Ym7/NDyMG/0Og8E7AXPR27mt2xCXaudD5Rz8jTrkREB89PKHNlEkbTFuQ6yPeqCH9OfkORDH9Wwpnrhmmn0djzM/EEcvf3UGwpuA8C+Grl9WhQ4AAA==";
    private static final Log log = LogFactory.getLog(FishingOperationsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected TabInfo catchesTab;
    protected EditCatchesUI catchesTabContent;
    protected BeanComboBox<FishingOperation> fishingOperationComboBox;
    protected TabInfo fishingOperationTab;
    protected EditFishingOperationUI fishingOperationTabContent;
    protected FishingOperationsUI fishingOperationsTopPanel = this;
    protected FishingOperationsUIHandler handler;
    protected FishingOperationsUIModel model;
    protected JButton newFishingOperationButton;
    protected JLabel noTraitPane;
    protected JTabbedPane tabPane;
    protected Table topPanel;
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationsUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            FishingOperationsUIHandler handler = new FishingOperationsUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishingOperationsUI() {
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public TabInfo getCatchesTab() {
        return catchesTab;
    }

    public EditCatchesUI getCatchesTabContent() {
        return catchesTabContent;
    }

    public BeanComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public TabInfo getFishingOperationTab() {
        return fishingOperationTab;
    }

    public EditFishingOperationUI getFishingOperationTabContent() {
        return fishingOperationTabContent;
    }

    public FishingOperationsUIHandler getHandler() {
        return handler;
    }

    public FishingOperationsUIModel getModel() {
        return model;
    }

    public JButton getNewFishingOperationButton() {
        return newFishingOperationButton;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFishingOperationsTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane);
        add(noTraitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(fishingOperationTabContent);
        tabPane.add(catchesTabContent);
        fishingOperationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation"));
        catchesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.catches"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(fishingOperationComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(newFishingOperationButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(warningContainer, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.fishingOperations.help"));
    }

    protected void createCatchesTab() {
        $objectMap.put("catchesTab", catchesTab = new TabInfo());
        
        catchesTab.setTitle(_("tutti.label.tab.catches"));
    }

    protected void createCatchesTabContent() {
        $objectMap.put("catchesTabContent", catchesTabContent = new EditCatchesUI(this));
        
        catchesTabContent.setName("catchesTabContent");
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setI18nPrefix("tutti.property.");
        fishingOperationComboBox.setProperty("selectedFishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.fishingOperations.field.fishingOperation.help");
    }

    protected void createFishingOperationTab() {
        $objectMap.put("fishingOperationTab", fishingOperationTab = new TabInfo());
        
        fishingOperationTab.setTitle(_("tutti.label.tab.fishingOperation"));
    }

    protected void createFishingOperationTabContent() {
        $objectMap.put("fishingOperationTabContent", fishingOperationTabContent = new EditFishingOperationUI(this));
        
        fishingOperationTabContent.setName("fishingOperationTabContent");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishingOperationsUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationsUIModel.class));
    }

    protected void createNewFishingOperationButton() {
        $objectMap.put("newFishingOperationButton", newFishingOperationButton = new JButton());
        
        newFishingOperationButton.setName("newFishingOperationButton");
        newFishingOperationButton.setToolTipText(_("tutti.fishingOperations.action.newFishingOperation.tip"));
        newFishingOperationButton.putClientProperty("help", "tutti.fishingOperations.action.newFishingOperation.help");
        newFishingOperationButton.putClientProperty("tuttiAction", NewFishingOperationAction.class);
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.fishingOperations.info.no.fishingOperation.selected"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(_("tutti.fishingOperations.warn.invalid.batch.model"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFishingOperationsTopPanel();
        addChildrenToTopPanel();
        addChildrenToWarningContainer();
        addChildrenToTabPane();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        fishingOperationComboBox.setBean(model);
        newFishingOperationButton.setIcon(SwingUtil.createActionIcon("add"));
        newFishingOperationButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.fishingOperations.action.newFishingOperation.mnemonic"),'Z'));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, fishingOperationsTopPanel, "tutti.fishingOperations.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.fishingOperations.field.fishingOperation.help");
        registerHelpId(_broker, newFishingOperationButton, "tutti.fishingOperations.action.newFishingOperation.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("fishingOperationsTopPanel", fishingOperationsTopPanel);
        createHandler();
        createModel();
        createBroker();
        createTopPanel();
        createFishingOperationComboBox();
        createNewFishingOperationButton();
        createWarningContainer();
        createWarningLabel();
        createTabPane();
        createFishingOperationTabContent();
        createCatchesTabContent();
        createNoTraitPane();
        createFishingOperationTab();
        createCatchesTab();
        // inline creation of fishingOperationsTopPanel
        setName("fishingOperationsTopPanel");
        setLayout(new BorderLayout());
        fishingOperationsTopPanel.putClientProperty("help", "tutti.fishingOperations.help");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getSelectedFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_TAB_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesTab.setEnabled(model.getSelectedFishingOperation() != null && model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
    }

}