package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolUIModel.java 546 2013-03-06 08:11:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditProtocolUIModel extends AbstractTuttiTableUIModel<TuttiProtocol, EditProtocolSpeciesRowModel, EditProtocolUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_LENGTH_CLASSES_PMFM_ID = "lengthClassesPmfmId";

    public static final String PROPERTY_GEAR_USE_FEATURE_PMFM_ID = "gearUseFeaturePmfmId";

    public static final String PROPERTY_VESSEL_USE_FEATURE_PMFM_ID = "vesselUseFeaturePmfmId";

    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";

    public static final String PROPERTY_IMPORTED = "imported";

    public static final String PROPERTY_CLONED = "cloned";

    protected String name;

    protected String comment;

    protected List<String> lengthClassesPmfmId;

    protected List<String> gearUseFeaturePmfmId;

    protected List<String> vesselUseFeaturePmfmId;

    /**
     * Flag when a incoming protocol is imported.
     *
     * @since 1.0
     */
    protected boolean imported;

    /**
     * Flag when a incoming protocol is cloned.
     *
     * @since 1.0
     */
    protected boolean cloned;

    /**
     * Can user remove a selected species?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesEnabled;

    protected List<Species> allSpecies;

    protected List<Species> allSynonyms;

    protected Multimap<String, Species> allSpeciesByTaxonId;

    protected Map<String, Species> allReferentSpeciesByTaxonId;

    protected List<Caracteristic> caracteristics;

    protected Map<String, Caracteristic> allCaracteristic;

    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder =
            BinderFactory.newBinder(EditProtocolUIModel.class,
                                    TuttiProtocol.class);

    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder =
            BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);

    private List<TuttiProtocol> existingProtocols;

    public EditProtocolUIModel() {
        super(TuttiProtocol.class, fromBeanBinder, toBeanBinder);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        Object oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<String> getLengthClassesPmfmId() {
        return lengthClassesPmfmId;
    }

    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        this.lengthClassesPmfmId = lengthClassesPmfmId;
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, lengthClassesPmfmId);
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        List<String> ids = TuttiEntities.collecIds(lengthClassesPmfm);
        setLengthClassesPmfmId(ids);
    }

    public List<String> getGearUseFeaturePmfmId() {
        return gearUseFeaturePmfmId;
    }

    public void setGearUseFeaturePmfmId(List<String> gearUseFeaturePmfmId) {
        Object oldValue = getGearUseFeaturePmfmId();
        this.gearUseFeaturePmfmId = gearUseFeaturePmfmId;
        firePropertyChange(PROPERTY_GEAR_USE_FEATURE_PMFM_ID, oldValue, gearUseFeaturePmfmId);
    }

    public void setGearUseFeaturePmfm(List<Caracteristic> gearUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(gearUseFeaturePmfm);
        setGearUseFeaturePmfmId(ids);
    }

    public List<String> getVesselUseFeaturePmfmId() {
        return vesselUseFeaturePmfmId;
    }

    public void setVesselUseFeaturePmfmId(List<String> vesselUseFeaturePmfmId) {
        Object oldValue = getVesselUseFeaturePmfmId();
        this.vesselUseFeaturePmfmId = vesselUseFeaturePmfmId;
        firePropertyChange(PROPERTY_VESSEL_USE_FEATURE_PMFM_ID, oldValue, vesselUseFeaturePmfmId);
    }

    public void setVesselUseFeaturePmfm(List<Caracteristic> vesselUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(vesselUseFeaturePmfm);
        setVesselUseFeaturePmfmId(ids);
    }

    public boolean isRemoveSpeciesEnabled() {
        return removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        Object oldValue = isRemoveSpeciesEnabled();
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, oldValue, removeSpeciesEnabled);
    }

    public boolean isImported() {
        return imported;
    }

    public void setImported(boolean imported) {
        Object oldValue = isImported();
        this.imported = imported;
        firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return cloned;
    }

    public void setCloned(boolean cloned) {
        Object oldValue = isCloned();
        this.cloned = cloned;
        firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public List<TuttiProtocol> getExistingProtocols() {
        return existingProtocols;
    }

    public void setExistingProtocols(List<TuttiProtocol> existingProtocols) {
        this.existingProtocols = existingProtocols;
    }

    public List<Species> getAllSpecies() {
        return allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (allReferentSpeciesByTaxonId != null && allSpecies != null) {
            allSynonyms = Lists.newArrayList(allSpecies);
            allSynonyms.removeAll(allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return allSpeciesByTaxonId.get(taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && allSpecies != null) {
            allSynonyms = Lists.newArrayList(allSpecies);
            allSynonyms.removeAll(allReferentSpeciesByTaxonId.values());
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }
}