package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditProtocolUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED = "addSpeciesProtocolButton.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED = "removeSpeciesProtocolButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SAVE_WARNING_CONTAINER_VISIBLE = "saveWarningContainer.visible";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesProtocolButton;
    protected TuttiHelpBroker broker;
    protected JPanel caracteristicActions;
    protected JTabbedPane caracteristicPane;
    protected JPanel caracteristicPanel;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected EditProtocolUI editProtocolTopPanel = this;
    protected JButton exportAllCaracteristicButton;
    protected JButton exportCaracteristicButton;
    protected JButton exportSpeciesButton;
    protected BeanDoubleList<Caracteristic> gearUseFeatureList;
    protected EditProtocolUIHandler handler;
    protected JButton importCaracteristicButton;
    protected JButton importSpeciesButton;
    protected BeanDoubleList<Caracteristic> lengthClassesList;
    protected EditProtocolUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected Table protocolInfoForm;
    protected JMenuItem removeSpeciesProtocolButton;
    protected JButton saveButton;
    protected JLabel saveWarning;
    protected JPanel saveWarningContainer;
    protected JButton selectOtherSpeciesButton;
    protected JPanel speciesActions;
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JPanel speciesPanel;
    protected JXTable speciesTable;
    protected JPopupMenu tablePopup;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected BeanDoubleList<Caracteristic> vesselUseFeatureList;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private TabInfo $TabInfo7;
    private TabInfo $TabInfo8;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProtocolUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditProtocolUIHandler handler = new EditProtocolUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI() {
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesProtocolButton() {
        return addSpeciesProtocolButton;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCaracteristicActions() {
        return caracteristicActions;
    }

    public JTabbedPane getCaracteristicPane() {
        return caracteristicPane;
    }

    public JPanel getCaracteristicPanel() {
        return caracteristicPanel;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JButton getExportAllCaracteristicButton() {
        return exportAllCaracteristicButton;
    }

    public JButton getExportCaracteristicButton() {
        return exportCaracteristicButton;
    }

    public JButton getExportSpeciesButton() {
        return exportSpeciesButton;
    }

    public BeanDoubleList<Caracteristic> getGearUseFeatureList() {
        return gearUseFeatureList;
    }

    public EditProtocolUIHandler getHandler() {
        return handler;
    }

    public JButton getImportCaracteristicButton() {
        return importCaracteristicButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public BeanDoubleList<Caracteristic> getLengthClassesList() {
        return lengthClassesList;
    }

    public EditProtocolUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public Table getProtocolInfoForm() {
        return protocolInfoForm;
    }

    public JMenuItem getRemoveSpeciesProtocolButton() {
        return removeSpeciesProtocolButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JLabel getSaveWarning() {
        return saveWarning;
    }

    public JPanel getSaveWarningContainer() {
        return saveWarningContainer;
    }

    public JButton getSelectOtherSpeciesButton() {
        return selectOtherSpeciesButton;
    }

    public JPanel getSpeciesActions() {
        return speciesActions;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JPanel getSpeciesPanel() {
        return speciesPanel;
    }

    public JXTable getSpeciesTable() {
        return speciesTable;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return validator;
    }

    public BeanDoubleList<Caracteristic> getVesselUseFeatureList() {
        return vesselUseFeatureList;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    protected TabInfo get$TabInfo8() {
        return $TabInfo8;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCaracteristicActions() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicActions.add(importCaracteristicButton);
        caracteristicActions.add(exportCaracteristicButton);
        caracteristicActions.add(exportAllCaracteristicButton);
    }

    protected void addChildrenToCaracteristicPane() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPane.add(lengthClassesList);
        caracteristicPane.add(gearUseFeatureList);
        caracteristicPane.add(vesselUseFeatureList);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 0));
        caracteristicPane.setTitleAt(0, _("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 1));
        caracteristicPane.setTitleAt(1, _("tutti.editProtocol.tab.caracteristic.gearUseFeature"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 2));
        caracteristicPane.setTitleAt(2, _("tutti.editProtocol.tab.caracteristic.vesselUseFeature"));
    }

    protected void addChildrenToCaracteristicPanel() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPanel.add(caracteristicActions, BorderLayout.NORTH);
        caracteristicPanel.add(caracteristicPane, BorderLayout.CENTER);
    }

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToEditProtocolTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JTabbedPane0, BorderLayout.CENTER);
        add(saveWarningContainer, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!allComponentsCreated) {
            return;
        }
        protocolInfoForm.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaveWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        saveWarningContainer.add(saveWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesActions() {
        if (!allComponentsCreated) {
            return;
        }
        speciesActions.add(importSpeciesButton);
        speciesActions.add(exportSpeciesButton);
    }

    protected void addChildrenToSpeciesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesPanel.add(speciesActions, BorderLayout.NORTH);
        speciesPanel.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeSpeciesProtocolButton);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesProtocolButton() {
        $objectMap.put("addSpeciesProtocolButton", addSpeciesProtocolButton = new JButton());
        
        addSpeciesProtocolButton.setName("addSpeciesProtocolButton");
        addSpeciesProtocolButton.setToolTipText(_("tutti.editProtocol.action.addSpeciesProtocol.tip"));
        addSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addSpeciesProtocol.help");
        addSpeciesProtocolButton.putClientProperty("tuttiAction", AddSpeciesProtocolAction.class);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editProtocol.help"));
    }

    protected void createCaracteristicActions() {
        $objectMap.put("caracteristicActions", caracteristicActions = new JPanel());
        
        caracteristicActions.setName("caracteristicActions");
        caracteristicActions.setLayout(new GridLayout());
    }

    protected void createCaracteristicPane() {
        $objectMap.put("caracteristicPane", caracteristicPane = new JTabbedPane());
        
        caracteristicPane.setName("caracteristicPane");
        caracteristicPane.putClientProperty("help", "tutti.editProtocol.pane.caracteristic.help");
    }

    protected void createCaracteristicPanel() {
        $objectMap.put("caracteristicPanel", caracteristicPanel = new JPanel());
        
        caracteristicPanel.setName("caracteristicPanel");
        caracteristicPanel.setLayout(new BorderLayout());
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.editProtocol.action.closeEditProtocol"));
        closeButton.setToolTipText(_("tutti.editProtocol.action.closeEditProtocol.tip"));
        closeButton.putClientProperty("help", "tutti.editProtocol.action.closeEditProtocol.help");
        closeButton.putClientProperty("tuttiAction", fr.ifremer.tutti.ui.swing.content.SelectCruiseAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editProtocol.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editProtocol.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editProtocol.field.comment.help");
    }

    protected void createExportAllCaracteristicButton() {
        $objectMap.put("exportAllCaracteristicButton", exportAllCaracteristicButton = new JButton());
        
        exportAllCaracteristicButton.setName("exportAllCaracteristicButton");
        exportAllCaracteristicButton.setText(_("tutti.editProtocol.action.exportProtocolAllCaracteristic"));
        exportAllCaracteristicButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolAllCaracteristic.tip"));
        exportAllCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        exportAllCaracteristicButton.putClientProperty("tuttiAction", ExportAllCaracteristicAction.class);
    }

    protected void createExportCaracteristicButton() {
        $objectMap.put("exportCaracteristicButton", exportCaracteristicButton = new JButton());
        
        exportCaracteristicButton.setName("exportCaracteristicButton");
        exportCaracteristicButton.setText(_("tutti.editProtocol.action.exportProtocolCaracteristic"));
        exportCaracteristicButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolCaracteristic.tip"));
        exportCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        exportCaracteristicButton.putClientProperty("tuttiAction", ExportProtocolCaracteristicAction.class);
    }

    protected void createExportSpeciesButton() {
        $objectMap.put("exportSpeciesButton", exportSpeciesButton = new JButton());
        
        exportSpeciesButton.setName("exportSpeciesButton");
        exportSpeciesButton.setText(_("tutti.editProtocol.action.exportProtocolSpecies"));
        exportSpeciesButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolSpecies.tip"));
        exportSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolSpecies.help");
        exportSpeciesButton.putClientProperty("tuttiAction", ExportProtocolSpeciesAction.class);
    }

    protected void createGearUseFeatureList() {
        $objectMap.put("gearUseFeatureList", gearUseFeatureList = new BeanDoubleList<Caracteristic>());
        
        gearUseFeatureList.setName("gearUseFeatureList");
        gearUseFeatureList.setI18nPrefix("tutti.property.");
        gearUseFeatureList.setProperty("gearUseFeaturePmfm");
        gearUseFeatureList.setShowReset(true);
        gearUseFeatureList.putClientProperty("help", "tutti.editProtocol.field.gearUseFeature.help");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditProtocolUIHandler.class));
    }

    protected void createImportCaracteristicButton() {
        $objectMap.put("importCaracteristicButton", importCaracteristicButton = new JButton());
        
        importCaracteristicButton.setName("importCaracteristicButton");
        importCaracteristicButton.setText(_("tutti.editProtocol.action.importProtocolCaracteristic"));
        importCaracteristicButton.setToolTipText(_("tutti.editProtocol.action.importProtocolCaracteristic.tip"));
        importCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolCaracteristic.help");
        importCaracteristicButton.putClientProperty("tuttiAction", ImportProtocolCaracteristicAction.class);
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(_("tutti.editProtocol.action.importProtocolSpecies"));
        importSpeciesButton.setToolTipText(_("tutti.editProtocol.action.importProtocolSpecies.tip"));
        importSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolSpecies.help");
        importSpeciesButton.putClientProperty("tuttiAction", ImportProtocolSpeciesAction.class);
    }

    protected void createLengthClassesList() {
        $objectMap.put("lengthClassesList", lengthClassesList = new BeanDoubleList<Caracteristic>());
        
        lengthClassesList.setName("lengthClassesList");
        lengthClassesList.setI18nPrefix("tutti.property.");
        lengthClassesList.setProperty("lengthClassesPmfm");
        lengthClassesList.setShowReset(true);
        lengthClassesList.putClientProperty("help", "tutti.editProtocol.field.lengthClasses.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProtocolUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("validatorLabel", _("tutti.editProtocol.field.protocol.name"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.editProtocol.field.protocol.name"));
        nameLabel.setToolTipText(_("tutti.editProtocol.field.protocol.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editProtocol.field.name.help");
    }

    protected void createProtocolInfoForm() {
        $objectMap.put("protocolInfoForm", protocolInfoForm = new Table());
        
        protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveSpeciesProtocolButton() {
        $objectMap.put("removeSpeciesProtocolButton", removeSpeciesProtocolButton = new JMenuItem());
        
        removeSpeciesProtocolButton.setName("removeSpeciesProtocolButton");
        removeSpeciesProtocolButton.setText(_("tutti.editProtocol.action.removeSpeciesProtocol"));
        removeSpeciesProtocolButton.setToolTipText(_("tutti.editProtocol.action.removeSpeciesProtocol.tip"));
        removeSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeSpeciesProtocol.help");
        removeSpeciesProtocolButton.putClientProperty("tuttiAction", RemoveSpeciesProtocolAction.class);
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editProtocol.action.saveProtocol"));
        saveButton.setToolTipText(_("tutti.editProtocol.action.saveProtocol.tip"));
        saveButton.putClientProperty("help", "tutti.editProtocol.action.saveProtocol.help");
        saveButton.putClientProperty("tuttiAction", SaveProtocolAction.class);
    }

    protected void createSaveWarning() {
        $objectMap.put("saveWarning", saveWarning = new JLabel());
        
        saveWarning.setName("saveWarning");
    }

    protected void createSaveWarningContainer() {
        $objectMap.put("saveWarningContainer", saveWarningContainer = new JPanel());
        
        saveWarningContainer.setName("saveWarningContainer");
        saveWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createSelectOtherSpeciesButton() {
        $objectMap.put("selectOtherSpeciesButton", selectOtherSpeciesButton = new JButton());
        
        selectOtherSpeciesButton.setName("selectOtherSpeciesButton");
        selectOtherSpeciesButton.setText(_("tutti.editProtocol.action.selectOtherSpecies"));
        selectOtherSpeciesButton.setToolTipText(_("tutti.editProtocol.action.selectOtherSpecies.tip"));
        selectOtherSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherSpecies.help");
        selectOtherSpeciesButton.putClientProperty("tuttiAction", SelectOtherSpeciesAction.class);
    }

    protected void createSpeciesActions() {
        $objectMap.put("speciesActions", speciesActions = new JPanel());
        
        speciesActions.setName("speciesActions");
        speciesActions.setLayout(new GridLayout());
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setShowReset(true);
        speciesComboBox.setToolTipText(_("tutti.editProtocol.field.species.tip"));
        speciesComboBox.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesPanel() {
        $objectMap.put("speciesPanel", speciesPanel = new JPanel());
        
        speciesPanel.setName("speciesPanel");
        speciesPanel.setLayout(new BorderLayout());
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new JXTable());
        
        speciesTable.setName("speciesTable");
        speciesTable.setSortable(false);
        speciesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesTable"));
        speciesTable.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProtocolUIModel.class, null));
    }

    protected void createVesselUseFeatureList() {
        $objectMap.put("vesselUseFeatureList", vesselUseFeatureList = new BeanDoubleList<Caracteristic>());
        
        vesselUseFeatureList.setName("vesselUseFeatureList");
        vesselUseFeatureList.setI18nPrefix("tutti.property.");
        vesselUseFeatureList.setProperty("vesselUseFeaturePmfm");
        vesselUseFeatureList.setShowReset(true);
        vesselUseFeatureList.putClientProperty("help", "tutti.editProtocol.field.vesselUseFeature.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditProtocolTopPanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add(protocolInfoForm);
        $JTabbedPane0.add(caracteristicPanel);
        $JTabbedPane0.add(speciesPanel);
        $JTabbedPane0.add($JLabel0);
        $JTabbedPane0.add($JLabel1);
        $JTabbedPane0.add($JLabel2);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("tutti.editProtocol.tab.info"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("tutti.editProtocol.tab.caracteristic"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 2));
        $JTabbedPane0.setTitleAt(2, _("tutti.editProtocol.tab.species"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 3));
        $JTabbedPane0.setTitleAt(3, _("tutti.editProtocol.tab.benthos"));
        $JTabbedPane0.setEnabledAt(3, false);
        $TabInfo7.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 4));
        $JTabbedPane0.setTitleAt(4, _("tutti.editProtocol.tab.plankton"));
        $JTabbedPane0.setEnabledAt(4, false);
        $TabInfo8.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 5));
        $JTabbedPane0.setTitleAt(5, _("tutti.editProtocol.tab.accidental"));
        $JTabbedPane0.setEnabledAt(5, false);
        addChildrenToProtocolInfoForm();
        addChildrenToCommentPane();
        addChildrenToCaracteristicPanel();
        addChildrenToCaracteristicActions();
        addChildrenToCaracteristicPane();
        addChildrenToSpeciesPanel();
        addChildrenToSpeciesActions();
        // inline complete setup of $Table0
        $Table0.add(speciesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(selectOtherSpeciesButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addSpeciesProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(speciesTable);
        addChildrenToSaveWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(saveButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 45 property setters
        lengthClassesList.setBeanType(Caracteristic.class);
        gearUseFeatureList.setBeanType(Caracteristic.class);
        vesselUseFeatureList.setBeanType(Caracteristic.class);
        speciesComboBox.setBeanType(Species.class);
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        $JLabel1.setHorizontalAlignment(JLabel.CENTER);
        $JLabel2.setHorizontalAlignment(JLabel.CENTER);
        removeSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.removeSpeciesProtocol.mnemonic"),'Z'));
        nameLabel.setLabelFor(nameField);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editProgram.field.comment")));
        importCaracteristicButton.setIcon(SwingUtil.createActionIcon("import"));
        importCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.importProtocolCaracteristic.mnemonic"),'Z'));
        exportCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolCaracteristic.mnemonic"),'Z'));
        exportAllCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportAllCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolAllCaracteristic.mnemonic"),'Z'));
        caracteristicPane.setTabPlacement(JTabbedPane.LEFT);
        lengthClassesList.setBean(model);
        gearUseFeatureList.setBean(model);
        vesselUseFeatureList.setBean(model);
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        importSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.importProtocolSpecies.mnemonic"),'Z'));
        exportSpeciesButton.setIcon(SwingUtil.createActionIcon("export"));
        exportSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolSpecies.mnemonic"),'Z'));
        selectOtherSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.selectOtherSpecies.mnemonic"),'Z'));
        addSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        addSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.addSpeciesProtocol.mnemonic"),'Z'));
        speciesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        speciesTable.setSelectionForeground(Color.BLACK);
        speciesTable.setSelectionBackground(null);
        saveWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        saveWarning.setIcon(SwingUtil.createActionIcon("warning"));
        saveWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.closeEditProtocol.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.saveProtocol.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editProtocolTopPanel, "tutti.editProtocol.help");
        registerHelpId(_broker, removeSpeciesProtocolButton, "tutti.editProtocol.action.removeSpeciesProtocol.help");
        registerHelpId(_broker, nameLabel, "tutti.editProtocol.field.name.help");
        registerHelpId(_broker, commentPane, "tutti.editProtocol.field.comment.help");
        registerHelpId(_broker, importCaracteristicButton, "tutti.editProtocol.action.importProtocolCaracteristic.help");
        registerHelpId(_broker, exportCaracteristicButton, "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        registerHelpId(_broker, exportAllCaracteristicButton, "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        registerHelpId(_broker, caracteristicPane, "tutti.editProtocol.pane.caracteristic.help");
        registerHelpId(_broker, lengthClassesList, "tutti.editProtocol.field.lengthClasses.help");
        registerHelpId(_broker, gearUseFeatureList, "tutti.editProtocol.field.gearUseFeature.help");
        registerHelpId(_broker, vesselUseFeatureList, "tutti.editProtocol.field.vesselUseFeature.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.editProtocol.action.importProtocolSpecies.help");
        registerHelpId(_broker, exportSpeciesButton, "tutti.editProtocol.action.exportProtocolSpecies.help");
        registerHelpId(_broker, speciesComboBox, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, selectOtherSpeciesButton, "tutti.editProtocol.action.selectOtherSpecies.help");
        registerHelpId(_broker, addSpeciesProtocolButton, "tutti.editProtocol.action.addSpeciesProtocol.help");
        registerHelpId(_broker, speciesTable, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, closeButton, "tutti.editProtocol.action.closeEditProtocol.help");
        registerHelpId(_broker, saveButton, "tutti.editProtocol.action.saveProtocol.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editProtocolTopPanel", editProtocolTopPanel);
        createHandler();
        createModel();
        createBroker();
        createValidator();
        createTablePopup();
        createRemoveSpeciesProtocolButton();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        createProtocolInfoForm();
        createNameLabel();
        createNameField();
        createCommentPane();
        createCommentField();
        createCaracteristicPanel();
        createCaracteristicActions();
        createImportCaracteristicButton();
        createExportCaracteristicButton();
        createExportAllCaracteristicButton();
        createCaracteristicPane();
        createLengthClassesList();
        createGearUseFeatureList();
        createVesselUseFeatureList();
        createSpeciesPanel();
        createSpeciesActions();
        createImportSpeciesButton();
        createExportSpeciesButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesComboBox();
        createSelectOtherSpeciesButton();
        createAddSpeciesProtocolButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSpeciesTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("tutti.to.be.done"));
        createSaveWarningContainer();
        createSaveWarning();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("tutti.editProtocol.tab.info"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("tutti.editProtocol.tab.caracteristic"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("tutti.editProtocol.tab.caracteristic.gearUseFeature"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("tutti.editProtocol.tab.caracteristic.vesselUseFeature"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("tutti.editProtocol.tab.species"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setEnabled(false);
        $TabInfo6.setTitle(_("tutti.editProtocol.tab.benthos"));
        // inline creation of $TabInfo7
        $objectMap.put("$TabInfo7", $TabInfo7 = new TabInfo());
        
        $TabInfo7.setEnabled(false);
        $TabInfo7.setTitle(_("tutti.editProtocol.tab.plankton"));
        // inline creation of $TabInfo8
        $objectMap.put("$TabInfo8", $TabInfo8 = new TabInfo());
        
        $TabInfo8.setEnabled(false);
        $TabInfo8.setTitle(_("tutti.editProtocol.tab.accidental"));
        // inline creation of editProtocolTopPanel
        setName("editProtocolTopPanel");
        setLayout(new BorderLayout());
        editProtocolTopPanel.putClientProperty("help", "tutti.editProtocol.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesProtocolButton.setEnabled(model.isRemoveSpeciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.setEnabled(!speciesComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    addSpeciesProtocolButton.setEnabled(speciesComboBox.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cloned", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveWarningContainer.setVisible(model.isImported() || model.isCloned());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cloned", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}