/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExportProtocolAction.class);
    protected File file;

    public ExportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler, "exportProtocol", "export", I18n._((String)"tutti.action.exportProtocol", (Object[])new Object[0]), I18n._((String)"tutti.action.exportProtocol.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolExportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolFile", (Object[])new Object[0]), null, "^.+\\.tuttiProtocol$", I18n._((String)"tutti.file.protocol", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        TuttiProtocol protocol = ((SelectCruiseUIModel)((Object)this.getModel())).getProtocol();
        Preconditions.checkNotNull((Object)protocol);
        if (log.isInfoEnabled()) {
            log.info((Object)("Export protocol: " + protocol.getId()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save protocol " + protocol.getId() + " to file: " + this.file));
        }
        if (!this.file.getName().endsWith(".tuttiProtocol")) {
            this.file = new File(this.file.getParentFile(), this.file.getName() + ".tuttiProtocol");
        }
        TuttiProtocolImportExportService service = this.getService(TuttiProtocolImportExportService.class);
        service.exportProtocol(protocol, this.file);
        this.sendMessage("Protocole [" + protocol.getName() + "] export\u00e9 dans le fichier " + this.file.getName() + ".");
        ((SelectCruiseUIHandler)this.getHandler()).resetEditProtolAction();
    }
}

