/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiConfigUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.widget.SwingSession;

public class MainUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, MainUI> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    public static final String CLONE_PROTOCOL = "cloneProtocol";
    protected JComponent currentBody;
    protected PersistenceService persistenceService;

    protected MainUIHandler(TuttiUIContext context, MainUI ui) {
        super(context, ui);
        this.persistenceService = context.getService(PersistenceService.class);
        context.setMainUI(ui);
        context.setActionUI(new TuttiActionUI(ui, context));
    }

    protected MainUIHandler(TuttiUIContext context) {
        super(context, null);
        this.persistenceService = null;
    }

    @Override
    public void beforeInitUI() {
        this.context.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (TuttiUIContext.ID_TO_SAVE_PROPERTIES.contains(propertyName)) {
                    MainUIHandler.this.changeTitle();
                } else if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((TuttiScreen)((Object)evt.getNewValue()));
                }
            }
        });
        ((MainUI)this.ui).setContextValue(this.ui, MainUI.class.getName());
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SwingSession swingSession = this.context.getSwingSession();
        swingSession.add((Component)((Object)this.ui));
        swingSession.save();
        this.changeTitle();
        JToolBar bar = ((MainUI)this.ui).getBottomBar();
        ((MainUI)this.ui).getStatus().addWidget((Component)bar, 0);
        if (!this.context.isDbExist()) {
            this.context.clearDbContext();
            this.context.setScreen(TuttiScreen.MANAGE_DB);
        } else {
            OpenDbAction openDbAction = this.createAction(OpenDbAction.class);
            openDbAction.actionPerformed(null);
        }
    }

    @Override
    public void onCloseUI() {
        this.context.close();
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void closeTutti() {
        RunTutti.closeTutti((MainUI)this.ui, true);
    }

    public void reloadTutti() {
        RunTutti.closeTutti((MainUI)this.ui, false);
        RunTutti.startTutti(this.context);
    }

    public void reloadApplication() {
    }

    public void reloadShortcuts() {
    }

    public void showConfig() {
        TuttiConfigUI configUI = new TuttiConfigUI((MainUI)this.ui);
        configUI.createUI();
    }

    public void showManageProtocol() {
        this.context.setScreen(TuttiScreen.EDIT_PROTOCOL);
    }

    public void showSelectCampaign() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void showFillCatches() {
        this.context.setValidationContext("edit");
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showValidateCatches() {
        this.context.setValidationContext("validate");
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showAbout() {
        ApplicationConfig applicationConfig = this.context.getConfig().getApplicationConfig();
        String iconPath = applicationConfig.getOption("application.icon.path");
        String name = "tutti-ui-swing";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n._((String)"tutti.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n._((String)"tutti.about.message", (Object[])new Object[0]));
        TuttiApplicationConfig config = this.context.getConfig();
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        about.setBottomText(I18n._((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        about.setIconPath(iconPath);
        about.setLicenseFile(licensePath);
        about.setThirdpartyFile(thirdPartyPath);
        about.buildTopPanel();
        about.init();
        about.showInDialog((Frame)((Object)this.ui), true);
        this.context.getSwingSession().add((Component)about);
    }

    public void gotoSite() {
        TuttiApplicationConfig config = this.context.getConfig();
        URL siteURL = config.getSiteUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("goto " + siteURL));
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception e) {
                TuttiUIContext.getErrorHelper().showErrorDialog("Failed to open '" + siteURL + "' in browser", e);
            }
        }
    }

    @Override
    public final void showInformationMessage(String message) {
        ((MainUI)this.ui).getStatus().setStatus(message);
    }

    public void registerValidator(SwingValidator validator) {
        ((MainUI)this.ui).getValidatorMessageWidget().registerValidator(validator);
    }

    @Override
    public void clearValidators() {
        ((MainUI)this.ui).getValidatorMessageWidget().clearValidators();
    }

    public AbstractTuttiUIHandler getCurrentHandler() {
        TuttiUI body = (TuttiUI)((Object)this.currentBody);
        return body.getHandler();
    }

    public void reloadPersistenceService() {
        this.persistenceService = this.context.reloadPersistenceService();
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    protected void setScreen(TuttiScreen screen) {
        try {
            if (this.currentBody != null) {
                TuttiUI body = (TuttiUI)((Object)this.currentBody);
                ((AbstractTuttiUIHandler)body.getHandler()).onCloseUI();
                this.context.getSwingSession().save();
                ((MainUI)this.ui).getBody().remove((Component)this.currentBody);
                this.currentBody = null;
            }
            if (screen != null) {
                Icon icon;
                String screenTitle;
                JPanel screenUI;
                String programId = this.context.getProgramId();
                String cruiseId = this.context.getCruiseId();
                String protocolId = this.context.getProtocolId();
                switch (screen) {
                    default: {
                        screenUI = new DbManagerUI(this.ui);
                        screenTitle = I18n._((String)"tutti.title.manageDb", (Object[])new Object[0]);
                        icon = ((MainUI)this.ui).getMenuActionManageDb().getIcon();
                        break;
                    }
                    case SELECT_CRUISE: {
                        screenUI = new SelectCruiseUI(this.ui);
                        screenTitle = I18n._((String)"tutti.title.home", (Object[])new Object[0]);
                        icon = ((MainUI)this.ui).getMenuActionSelectCruise().getIcon();
                        break;
                    }
                    case EDIT_PROGRAM: {
                        screenTitle = programId == null ? I18n._((String)"tutti.title.create.program", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.program", (Object[])new Object[0]);
                        screenUI = new EditProgramUI(this.ui);
                        icon = ((MainUI)this.ui).getMenuActionEditProgram().getIcon();
                        break;
                    }
                    case EDIT_CRUISE: {
                        screenTitle = cruiseId == null ? I18n._((String)"tutti.title.create.cruise", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.cruise", (Object[])new Object[0]);
                        screenUI = new EditCruiseUI(this.ui);
                        icon = ((MainUI)this.ui).getMenuActionEditCruise().getIcon();
                        break;
                    }
                    case EDIT_PROTOCOL: {
                        screenTitle = protocolId == null ? I18n._((String)"tutti.title.create.protocol", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.protocol", (Object[])new Object[0]);
                        screenUI = new EditProtocolUI(this.ui);
                        icon = ((MainUI)this.ui).getMenuActionEditProtocol().getIcon();
                        break;
                    }
                    case CLONE_PROTOCOL: {
                        screenTitle = I18n._((String)"tutti.title.create.protocol", (Object[])new Object[0]);
                        ((MainUI)this.ui).setContextValue(true, CLONE_PROTOCOL);
                        screenUI = new EditProtocolUI(this.ui);
                        icon = ((MainUI)this.ui).getMenuActionEditProtocol().getIcon();
                        break;
                    }
                    case EDIT_FISHING_OPERATION: {
                        String validationContext = this.context.getValidationContext();
                        if ("edit".equals(validationContext)) {
                            screenTitle = I18n._((String)"tutti.title.edit.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                            icon = ((MainUI)this.ui).getMenuActionEditCatches().getIcon();
                        } else {
                            screenTitle = I18n._((String)"tutti.title.validate.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                            icon = ((MainUI)this.ui).getMenuActionValidateCatches().getIcon();
                        }
                        screenUI = new FishingOperationsUI(this.ui);
                        break;
                    }
                    case IMPORT_TEMPORARY_REFERENTIAL: {
                        screenTitle = I18n._((String)"tutti.title.import.temporary.referential", (Object[])new Object[0]);
                        screenUI = new ManageTemporaryReferentialUI(this.ui);
                        icon = ((MainUI)this.ui).getMenuImportTemporaryReferential().getIcon();
                    }
                }
                this.currentBody = screenUI;
                this.context.getSwingSession().add((Component)this.currentBody);
                ((MainUI)this.ui).getBody().setTitle(screenTitle);
                ((MainUI)this.ui).getBody().add((Component)this.currentBody);
                ((MainUI)this.ui).getBody().setLeftDecoration((JComponent)new JLabel(icon));
            }
        }
        catch (Exception e) {
            AbstractTuttiAction mainAction = AbstractTuttiAction.getMainAction();
            if (mainAction != null) {
                mainAction.setFailed(true);
            }
            TuttiUIContext.getErrorHelper().showErrorDialog("Could not change to screen " + (Object)((Object)screen), e);
            this.context.setScreen(TuttiScreen.SELECT_CRUISE);
        }
    }

    protected void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        ((MainUI)this.ui).setTitle("Tutti - v " + this.getConfig().getVersion() + " [ " + title + " ]");
    }

    protected String getSelectedCruiseTitle() {
        String title;
        if (this.context.isDbLoaded()) {
            String programId = this.context.getProgramId();
            if (programId == null) {
                title = I18n._((String)"tutti.title.noSelectedProgram", (Object[])new Object[0]);
            } else {
                Program program = this.persistenceService.getProgram(programId);
                title = I18n._((String)"tutti.title.selectedProgram", (Object[])new Object[]{program.getName()}) + " / ";
                String cruiseId = this.context.getCruiseId();
                if (cruiseId == null) {
                    title = title + I18n._((String)"tutti.title.noSelectedCruise", (Object[])new Object[0]);
                } else {
                    Cruise cruise = this.persistenceService.getCruise(cruiseId);
                    title = title + I18n._((String)"tutti.title.selectedCruise", (Object[])new Object[]{cruise.getName()});
                }
                title = title + " / ";
                String protocolId = this.context.getProtocolId();
                if (protocolId == null) {
                    title = title + I18n._((String)"tutti.title.noSelectedProtocol", (Object[])new Object[0]);
                } else {
                    TuttiProtocol protocol = this.persistenceService.getProtocol(protocolId);
                    title = title + I18n._((String)"tutti.title.selectedProtocol", (Object[])new Object[]{protocol.getName()});
                }
            }
        } else {
            title = I18n._((String)"tutti.title.nodb", (Object[])new Object[0]);
        }
        return title;
    }
}

