/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import java.awt.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveFishingOperationAction
extends AbstractTuttiAction<EditFishingOperationUIModel, EditFishingOperationUI, EditFishingOperationUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SaveFishingOperationAction.class);
    protected boolean updateUI;

    public SaveFishingOperationAction(EditFishingOperationUIHandler handler) {
        super(handler, "saveFishingOperation", "save", I18n._((String)"tutti.action.saveFishingOperation", (Object[])new Object[0]), I18n._((String)"tutti.action.saveFishingOperation.tip", (Object[])new Object[0]), true);
    }

    public void setUpdateUI(boolean updateUI) {
        this.updateUI = updateUI;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        this.updateUI = true;
        super.releaseAction(event);
    }

    @Override
    protected void doAction(ActionEvent event) {
        boolean mustSave;
        EditFishingOperationUIHandler handler = (EditFishingOperationUIHandler)this.getHandler();
        TuttiBeanMonitor<EditFishingOperationUIModel> monitor = handler.getFishingOperationMonitor();
        EditFishingOperationUIModel beanToSave = monitor.getBean();
        boolean bl = mustSave = (beanToSave.isCreate() || !beanToSave.isEmpty()) && beanToSave.isValid();
        if (mustSave) {
            CaracteristicTabUIModel[] subModels;
            if (beanToSave.getCoordinateEditorType() != CoordinateEditorType.DD) {
                beanToSave.convertGearShootingCoordinatesDMSToDD();
            }
            FishingOperation toSave = (FishingOperation)beanToSave.toBean();
            for (CaracteristicTabUIModel subModel : subModels = handler.getSubModels()) {
                Class<CaracteristicTabUIModel> modelClass = subModel.getClass();
                CaracteristicMap caracteristics = subModel.getCaracteristicMap();
                if (modelClass.isAssignableFrom(EnvironmentTabUIModel.class)) {
                    toSave.setEnvironmentCaracteristics(caracteristics);
                    continue;
                }
                if (modelClass.isAssignableFrom(GearShootingTabUIModel.class)) {
                    toSave.setGearShootingCaracteristics(caracteristics);
                    continue;
                }
                if (!modelClass.isAssignableFrom(HydrologyTabUIModel.class)) continue;
                toSave.setHydrologyCaracteristics(caracteristics);
            }
            this.sendMessage("[ Trait - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications de " + this.decorate(toSave) + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + toSave.getId() + " was modified, will save it."));
            }
            monitor.clearModified();
            ((EditFishingOperationUIModel)this.getModel()).setModify(false);
            this.saveFishingOperation(toSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFishingOperation(FishingOperation toSave) {
        PersistenceService service = this.getService(PersistenceService.class);
        boolean create = TuttiEntities.isNew(toSave);
        FishingOperationsUIModel model = ((EditFishingOperationUIHandler)this.getHandler()).getParentUi().getModel();
        if (create) {
            FishingOperation savedFishingOperation = service.createFishingOperation(toSave);
            CatchBatch catchBatch = new CatchBatch();
            catchBatch.setFishingOperation(savedFishingOperation);
            service.createCatchBatch(catchBatch);
            model.addFishingOperation(savedFishingOperation);
            model.setSelectedFishingOperation(savedFishingOperation);
        } else {
            model.setEditionAdjusting(true);
            try {
                FishingOperation savedFishingOperation = service.saveFishingOperation(toSave);
                model.updateFishingOperation(savedFishingOperation);
            }
            finally {
                model.setEditionAdjusting(false);
            }
        }
    }
}

