package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProgramUIHandler.java 407 2013-02-12 18:40:17Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/program/EditProgramUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JOptionPane;
import java.awt.event.ActionEvent;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * Handler of UI {@link EditProgramUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditProgramUIHandler extends AbstractTuttiUIHandler<EditProgramUIModel, EditProgramUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditProgramUIHandler.class);

    /**
     * Persistence service.
     *
     * @since 0.1
     */
    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUI parentUi, EditProgramUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        EditProgramUIModel model = new EditProgramUIModel();

        //TODO 20130206 kmorin put the programs loaded in the home screen in a
        //kind of context to avoid loading the programs again
        List<Program> programs = persistenceService.getAllProgram();
        List<Program> loadedPrograms =
                Lists.newArrayListWithCapacity(programs.size());
        for (Program program : programs) {
            loadedPrograms.add(persistenceService.getProgram(program.getId()));
        }
        model.setExistingPrograms(loadedPrograms);

        String surveyId = context.getProgramId();
        if (surveyId == null) {

            if (log.isInfoEnabled()) {
                log.info("Edit new program");
            }
        } else {

            if (log.isInfoEnabled()) {
                log.info("Edit existing program " + surveyId);
            }
            // load existing program
            Program program = persistenceService.getProgram(surveyId);

            model.fromBean(program);

            model.getExistingPrograms().remove(program);
        }

        listModelIsModify(model);

        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        EditProgramUIModel model = getModel();
        initBeanComboBox(ui.getZoneComboBox(),
                         persistenceService.getAllProgramZone(),
                         model.getZone());

        SwingValidator validator = ui.getValidator();
        listenValidatorValid(validator, model);

        registerValidators(validator);

        // if new program can already cancel his creation
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info("closing: " + ui);
        }
        clearValidators();
    }

    @Override
    public boolean canCloseUI(TuttiScreen nextScreen) {
        boolean result = true;
        if (getModel().isModify()) {
            int answer = askSaveBeforeLeaving(_("tutti.dialog.askSaveBeforeLeaving.saveProgram"));
            result = answer == JOptionPane.NO_OPTION;
            if (answer == JOptionPane.YES_OPTION) {
                ActionEvent event = new ActionEvent(nextScreen, nextScreen.ordinal(), null);
                doAction(ui.getSaveButton(), event);
            }
        }
        return result;
    }

    @Override
    public SwingValidator<EditProgramUIModel> getValidator() {
        return ui.getValidator();
    }

}
