package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: RunTutti.java 429 2013-02-15 18:55:19Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/RunTutti.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import java.awt.Color;
import java.util.Arrays;

/**
 * To start Tutti application.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class RunTutti {

    /** Logger. */
    private static final Log log = LogFactory.getLog(RunTutti.class);

    public static final int UPATE_EXIT_CODE = 88;

    public static void main(String... args) {

        if (log.isInfoEnabled()) {
            log.info("Starting Tutti with arguments: " + Arrays.toString(args));
        }

        // override default exception management (after config init)
        Thread.setDefaultUncaughtExceptionHandler(new TuttiExceptionHandler());
        System.setProperty("sun.awt.exception.handler", TuttiExceptionHandler.class.getName());

        // Create configuration
        TuttiApplicationConfig config =
                new TuttiApplicationConfig("tutti.config", args);

        // Create application context
        final TuttiUIContext context = TuttiUIContext.newContext(config);

        // prepare context (mainly init configs, i18n)
        context.init();

        if (config.isFullLaunchMode()) {

            if (log.isInfoEnabled()) {
                log.info("Full launch mode, try to update.");
            }

            MainUIHandler handler = new MainUIHandler(context);

            // try to update jre - i18n - application and exit if so
            new UpdateApplicationAction(handler).doAction(null);

            // try to update db
//            new UpdateReferentialAction(handler).doAction(null);
        }

        // Prepare ui look&feel and load ui properties
        try {
            SwingUtil.initNimbusLoookAndFeel();
        } catch (Exception e) {
            // could not find nimbus look-and-feel
            if (log.isWarnEnabled()) {
                log.warn("Failed to init nimbus look and feel");
            }
        }

        UIManager.put("Table.focusCellHighlightBorder",
                      new BorderUIResource.LineBorderUIResource(Color.BLACK));

        startTutti(context);
    }

    public static void startTutti(TuttiUIContext context) {

        context.open();

        MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        mainUI.setVisible(true);
    }

    public static void closeTutti(MainUI ui, boolean exit) {

        ui.getHandler().getContext().getSwingSession().save();

        ui.getHandler().onCloseUI();

        ui.setVisible(false);
        ui.dispose();

        if (exit) {
            System.exit(0);
        }
    }
}