package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditSelectedProgramAction.java 330 2013-02-05 09:19:16Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/EditSelectedProgramAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * Opens the program edition screen to edit the selected program.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class EditSelectedProgramAction extends AbstractChangeScreenAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(EditSelectedProgramAction.class);

    public EditSelectedProgramAction(MainUIHandler handler) {
        super(handler,
              "editProgram",
              "program",
              _("tutti.action.editSelectedProgram"),
              _("tutti.action.editSelectedProgram.tip"),
              true
        );
    }

    @Override
    protected void doAction(ActionEvent e) {
        Preconditions.checkState(getContext().getProgramId() != null);
        if (log.isInfoEnabled()) {
            log.info("Edit program: " + getContext().getProgramId());
        }
        getContext().setScreen(getNextScreen());
    }

    @Override
    protected TuttiScreen getNextScreen() {
        return TuttiScreen.EDIT_PROGRAM;
    }

}
