/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.Set;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class SpeciesBatchTableModel
extends AbstractTuttiTableModel<SpeciesBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.table.species.batch.header.species", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.species", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SORTED_UNSORTED_CATEGORY = SampleColumnIdentifier.newId("sortedUnsortedCategory", "sortedUnsortedCategoryWeight", SampleCategoryType.sortedUnsorted, I18n.n_((String)"tutti.table.species.batch.header.sortedUnsortedCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.sortedUnsortedCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SIZE_CATEGORY = SampleColumnIdentifier.newId("sizeCategory", "sizeCategoryWeight", SampleCategoryType.size, I18n.n_((String)"tutti.table.species.batch.header.sizeCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.sizeCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SEX_CATEGORY = SampleColumnIdentifier.newId("sexCategory", "sexCategoryWeight", SampleCategoryType.sex, I18n.n_((String)"tutti.table.species.batch.header.sexCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.sexCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> MATURITY_CATEGORY = SampleColumnIdentifier.newId("maturityCategory", "maturityCategoryWeight", SampleCategoryType.maturity, I18n.n_((String)"tutti.table.species.batch.header.maturityCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.maturityCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> AGE_CATEGORY = SampleColumnIdentifier.newId("ageCategory", "ageCategoryWeight", SampleCategoryType.age, I18n.n_((String)"tutti.table.species.batch.header.ageCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.ageCategory", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId("computedOrNotWeight", I18n.n_((String)"tutti.table.species.batch.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.weight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId("computedOrNotNumber", I18n.n_((String)"tutti.table.species.batch.header.computedNumber", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.computedNumber", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId("comment", I18n.n_((String)"tutti.table.species.batch.header.comment", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.comment", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId("attachment", I18n.n_((String)"tutti.table.species.batch.header.file", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.file", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId("speciesToConfirm", I18n.n_((String)"tutti.table.species.batch.header.toConfirm", (Object[])new Object[0]), I18n.n_((String)"tutti.table.species.batch.header.toConfirm", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> frequencyCols;
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> sampleCols;
    protected final Multimap<Species, SampleCategoryType> speciesSampleCategories;

    public SpeciesBatchTableModel(TableColumnModelExt columnModel, Multimap<Species, SampleCategoryType> speciesSampleCategories) {
        super(columnModel, false, false);
        this.speciesSampleCategories = speciesSampleCategories;
        this.setNoneEditableCols(SPECIES);
        this.frequencyCols = Sets.newHashSet();
        this.frequencyCols.add(COMPUTED_NUMBER);
        this.frequencyCols.add(WEIGHT);
        this.sampleCols = Sets.newHashSet();
        this.sampleCols.add(SORTED_UNSORTED_CATEGORY);
        this.sampleCols.add(SIZE_CATEGORY);
        this.sampleCols.add(SEX_CATEGORY);
        this.sampleCols.add(MATURITY_CATEGORY);
        this.sampleCols.add(AGE_CATEGORY);
    }

    @Override
    public SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel();
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName, SpeciesBatchRowModel entry) {
        if (this.sampleCols.contains(propertyName)) {
            ((SampleColumnIdentifier)propertyName).setWeightValue(entry, aValue);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }
    }

    public void updateSamplingRatio(Set<SpeciesBatchRowModel> rows) {
    }

    @Override
    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result) {
            if (this.frequencyCols.contains(propertyName)) {
                SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(rowIndex);
                result = entry.isValid() && entry.isBatchLeaf();
            } else if (this.sampleCols.contains(propertyName)) {
                SampleColumnIdentifier samplePropertyName = (SampleColumnIdentifier)propertyName;
                SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(rowIndex);
                Species species = entry.getSpecies();
                if (species == null) {
                    result = false;
                } else {
                    boolean bl = result = !this.speciesSampleCategories.containsKey((Object)species) || this.speciesSampleCategories.containsEntry((Object)species, (Object)samplePropertyName.getSampleCategoryType());
                    if (result) {
                        SampleCategory value = (SampleCategory)propertyName.getValue(entry);
                        result = value.getCategoryValue() != null;
                    }
                }
            }
        }
        return result;
    }

    public static class SampleColumnIdentifier<R>
    extends ColumnIdentifier<R> {
        private static final long serialVersionUID = 1L;
        private final SampleCategoryType sampleCategoryType;
        private final String weightPropertyName;

        public static <R> SampleColumnIdentifier<R> newId(String propertyName, String weightPropertyName, SampleCategoryType sampleCategoryType, String headerI18nKey, String headerTipI18nKey) {
            return new SampleColumnIdentifier<R>(propertyName, weightPropertyName, sampleCategoryType, headerI18nKey, headerTipI18nKey);
        }

        protected SampleColumnIdentifier(String propertyName, String weightPropertyName, SampleCategoryType sampleCategoryType, String headerI18nKey, String headerTipI18nKey) {
            super(propertyName, headerI18nKey, headerTipI18nKey);
            this.weightPropertyName = weightPropertyName;
            this.sampleCategoryType = sampleCategoryType;
        }

        public void setWeightValue(R entry, Object value) {
            TuttiUIUtil.setProperty(entry, this.weightPropertyName, value);
        }

        public SampleCategoryType getSampleCategoryType() {
            return this.sampleCategoryType;
        }
    }
}

