/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import org.nuiton.util.decorator.Decorator;

public class CaracteristicValueRenderer
implements TableCellRenderer {
    protected int caracteristicColumn;
    protected Decorator<CaracteristicQualitativeValue> decorator;

    public CaracteristicValueRenderer(TuttiUIContext context) {
        this(0, context);
    }

    public CaracteristicValueRenderer(int caracteristicColumn, TuttiUIContext context) {
        this.caracteristicColumn = caracteristicColumn;
        DecoratorService decoratorService = context.getDecoratorService();
        this.decorator = decoratorService.getDecoratorByType(CaracteristicQualitativeValue.class);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer;
        Caracteristic caracteristic = (Caracteristic)table.getModel().getValueAt(row, this.caracteristicColumn);
        if (caracteristic == null) {
            renderer = table.getDefaultRenderer(Object.class);
        } else {
            switch (caracteristic.getCaracteristicType()) {
                case QUALITATIVE: {
                    renderer = new DecoratorTableCellRenderer(this.decorator);
                    break;
                }
                default: {
                    renderer = table.getDefaultRenderer(Object.class);
                }
            }
        }
        Component result = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        return result;
    }
}

