/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.config;

import com.google.common.io.Files;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.config.model.ConfigTableModel;
import jaxx.runtime.swing.config.model.OptionModel;
import jaxx.runtime.swing.editor.ClassCellEditor;
import jaxx.runtime.swing.editor.ColorCellEditor;
import jaxx.runtime.swing.editor.EnumEditor;
import jaxx.runtime.swing.editor.LocaleEditor;
import jaxx.runtime.swing.editor.cell.FileCellEditor;
import org.apache.commons.lang3.StringUtils;

public class ConfigTableEditor
implements TableCellEditor {
    protected TableCellEditor delegate;
    protected ConfigTableModel model;

    public ConfigTableEditor(ConfigTableModel model) {
        this.model = model;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate = this.findDelegate(table, this.model.getEntry(row));
        return this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return !this.hasDelegate() ? null : this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !this.hasDelegate() || this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.hasDelegate() && this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return !this.hasDelegate() || this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.hasDelegate()) {
            this.delegate.cancelCellEditing();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (this.hasDelegate()) {
            this.delegate.addCellEditorListener(l);
        }
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (this.hasDelegate()) {
            this.delegate.removeCellEditorListener(l);
        }
    }

    protected TableCellEditor findDelegate(JTable table, OptionModel option) {
        Class<?> type = option.getType();
        Object editor = table.getDefaultEditor(type);
        TableCellEditor defaultEditor = table.getDefaultEditor(Object.class);
        if (option.getEditor() != null) {
            editor = option.getEditor();
            table.setDefaultEditor(type, (TableCellEditor)editor);
        } else if (editor.equals(defaultEditor)) {
            editor = type.isEnum() ? new DefaultCellEditor((JComboBox<?>)EnumEditor.newEditor(type)) : (type.equals(Class.class) ? new ClassCellEditor() : (type.equals(File.class) ? new FileCellEditorWithExtDetector() : (type.equals(KeyStroke.class) ? JAXXWidgetUtil.newKeyStrokeTableCellEditor() : (type.equals(Locale.class) ? new DefaultCellEditor((JComboBox<?>)LocaleEditor.newEditor((Locale[])new Locale[0])) : (type.equals(Color.class) ? new ColorCellEditor() : table.getDefaultEditor(String.class))))));
            table.setDefaultEditor(type, (TableCellEditor)editor);
        }
        if (editor == null) {
            throw new IllegalStateException("could not find a editor for type +" + type);
        }
        return editor;
    }

    protected boolean hasDelegate() {
        return this.delegate != null;
    }

    protected static class FileCellEditorWithExtDetector
    extends FileCellEditor {
        private static final long serialVersionUID = 1L;

        protected FileCellEditorWithExtDetector() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String fileExtension;
            String string = fileExtension = value == null ? null : Files.getFileExtension((String)((File)value).getName());
            if (StringUtils.isNotEmpty((CharSequence)fileExtension)) {
                this.fileEditor.setExts(fileExtension);
                this.fileEditor.setAcceptAllFileFilterUsed(Boolean.valueOf(true));
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

