/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.model.JaxxFilterableComboBoxModel;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.DecoratorUtil;
import org.nuiton.util.decorator.JXPathDecorator;
import org.nuiton.util.decorator.MultiJXPathDecorator;

public class BeanFilterableComboBoxHandler<O>
implements PropertyChangeListener {
    public static final Log log = LogFactory.getLog(BeanFilterableComboBoxHandler.class);
    protected BeanFilterableComboBox<O> ui;
    protected Method mutator;
    protected MultiJXPathDecorator<O> decorator;
    protected boolean init;
    protected final FocusListener EDITOR_TEXT_COMP0NENT_FOCUSLISTENER = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("close popup from " + e));
            }
            BeanFilterableComboBoxHandler.this.ui.getPopup().setVisible(false);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };
    protected final DocumentListener EDITOR_TEXT_COMPONENT_DOCUMENTLISTENER = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        protected void updateFilter() {
            JComboBox comboBox = BeanFilterableComboBoxHandler.this.ui.getCombobox();
            JaxxFilterableComboBoxModel model = (JaxxFilterableComboBoxModel)comboBox.getModel();
            JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
            if (comboBox.isShowing()) {
                comboBox.hidePopup();
            }
            String text = editorComponent.getText();
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateFilter " + text));
            }
            model.setFilterText(text);
            if (comboBox.isShowing()) {
                comboBox.showPopup();
            }
        }
    };
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return BeanFilterableComboBoxHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return BeanFilterableComboBoxHandler.this.ui.getChangeDecorator();
        }
    };

    public BeanFilterableComboBoxHandler(BeanFilterableComboBox<O> ui) {
        this.ui = ui;
    }

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null");
        }
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.decorator = BeanUIUtil.createDecorator(decorator);
        final JComboBox combobox = this.ui.getCombobox();
        final JAXXFilterableComboBoxEditor editor = new JAXXFilterableComboBoxEditor(this.ui.getCombobox().getEditor());
        combobox.setEditor(editor);
        editor.getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                combobox.showPopup();
            }
        });
        editor.getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!combobox.isPopupVisible()) {
                    combobox.showPopup();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Object selectedItem = BeanFilterableComboBoxHandler.this.ui.getSelectedItem();
                String text = editor.getEditorComponent().getText();
                String selectedItemString = BeanFilterableComboBoxHandler.this.getBeanType().isInstance(selectedItem) ? BeanFilterableComboBoxHandler.this.decorator.toString(selectedItem) : JAXXUtil.getStringValue((Object)selectedItem);
                if (selectedItem == null || !selectedItemString.equals(text)) {
                    BeanFilterableComboBoxHandler.this.ui.setSelectedItem(null);
                }
            }
        });
        combobox.setRenderer(new DecoratorListCellRenderer(this.decorator));
        ((JaxxFilterableComboBoxModel)combobox.getModel()).setDecorator(this.decorator);
        combobox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        combobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("itemStateChanged selected " + item + " - " + (item != null ? item.getClass() : null)));
                    }
                    BeanFilterableComboBoxHandler.this.ui.setSelectedItem(e.getItem());
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("itemStateChanged deselected " + item + " - " + (item != null ? item.getClass() : null)));
                }
            }
        });
        this.popupHandler.preparePopup(this.ui.getSelectedToolTipText(), this.ui.getNotSelectedToolTipText(), this.ui.getI18nPrefix(), this.ui.getPopupTitleText(), (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.decorator);
        this.setFilterable(false, this.ui.getFilterable());
        this.ui.addPropertyChangeListener(this);
        this.ui.setData(data);
        indexes.setSelectedButton((Object)this.ui.getIndex());
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public boolean isEmpty() {
        boolean result = CollectionUtils.isEmpty(this.ui.getData());
        return result;
    }

    public void addItem(O item) {
        List<O> data = this.ui.getData();
        boolean wasEmpty = CollectionUtils.isEmpty(data);
        data.add(item);
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
        this.fireEmpty(wasEmpty);
    }

    public void removeItem(O item) {
        List<O> data = this.ui.getData();
        boolean remove = data.remove(item);
        if (remove) {
            Object selectedItem = this.ui.getSelectedItem();
            if (item == selectedItem) {
                this.ui.setSelectedItem(null);
            }
            this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
            this.fireEmpty(false);
        }
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    public void reset() {
        JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
        editorComponent.setText("");
        this.ui.setSelectedItem(null);
        JComboBox comboBox = this.ui.getCombobox();
        if (comboBox.isShowing()) {
            comboBox.hidePopup();
        }
    }

    protected void setFilterable(Boolean oldValue, Boolean newValue) {
        if ((oldValue = Boolean.valueOf(oldValue != null && oldValue != false)).equals(newValue = Boolean.valueOf(newValue != null && newValue != false))) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("filterable state : <" + oldValue + " to " + newValue + ">"));
        }
        if (!newValue.booleanValue()) {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.removeFocusListener(this.EDITOR_TEXT_COMP0NENT_FOCUSLISTENER);
            editorComponent.getDocument().removeDocumentListener(this.EDITOR_TEXT_COMPONENT_DOCUMENTLISTENER);
            ((JaxxFilterableComboBoxModel)this.ui.getCombobox().getModel()).setFilterText(null);
        } else {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.addFocusListener(this.EDITOR_TEXT_COMP0NENT_FOCUSLISTENER);
            editorComponent.getDocument().addDocumentListener(this.EDITOR_TEXT_COMPONENT_DOCUMENTLISTENER);
            this.EDITOR_TEXT_COMPONENT_DOCUMENTLISTENER.changedUpdate(null);
        }
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    protected void updateUI(int index, boolean reversesort) {
        this.decorator.setContextIndex(index);
        Object previousSelectedItem = this.ui.getSelectedItem();
        if (previousSelectedItem != null) {
            this.ui.getCombobox().setSelectedItem(null);
            this.ui.selectedItem = null;
        }
        List<O> data = this.ui.getData();
        try {
            DecoratorUtil.sort(this.decorator, data, (int)index, (boolean)reversesort);
        }
        catch (Exception eee) {
            log.warn((Object)eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillComboBox((JComboBox)this.ui.getCombobox(), data, null);
        if (previousSelectedItem != null) {
            this.ui.setSelectedItem(previousSelectedItem);
        }
        this.ui.getCombobox().requestFocus();
    }

    protected void setSelectedItem(O oldValue, O newValue) {
        if (this.ui.getBean() == null) {
            return;
        }
        if (newValue == null) {
            if (this.ui.getCombobox().getSelectedItem() == null) {
                return;
            }
            this.ui.getCombobox().setSelectedItem(null);
            if (oldValue == null) {
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.ui.getProperty() + " on " + this.getBeanType() + " :: " + oldValue + " to " + newValue));
        }
        try {
            Method mut = this.getMutator();
            if (mut != null) {
                mut.invoke(this.ui.getBean(), newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    public Class<O> getBeanType() {
        Class<O> result = this.ui.getBeanType();
        if (result == null) {
            result = this.decorator == null ? null : this.decorator.getType();
        }
        return result;
    }

    protected Method getMutator() {
        if (this.mutator == null && this.ui.getBean() != null && this.ui.getProperty() != null) {
            this.mutator = BeanUIUtil.getMutator(this.ui.getBean(), this.ui.getProperty());
        }
        return this.mutator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("selectedItem".equals(propertyName)) {
            this.setSelectedItem(evt.getOldValue(), evt.getNewValue());
            return;
        }
        if ("filterable".equals(propertyName)) {
            this.setFilterable((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            this.setIndex(null, this.ui.getIndex());
            List list = (List)evt.getOldValue();
            this.fireEmpty(CollectionUtils.isEmpty((Collection)list));
        }
    }

    protected void fireEmpty(boolean wasEmpty) {
        this.ui.firePropertyChange("empty", wasEmpty, this.isEmpty());
    }

    class JAXXFilterableComboBoxEditor
    implements ComboBoxEditor {
        Object oldItem;
        ComboBoxEditor wrapped;

        public JAXXFilterableComboBoxEditor(ComboBoxEditor wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public JTextComponent getEditorComponent() {
            return (JTextComponent)this.wrapped.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setItem " + anObject + " - " + (anObject != null ? anObject.getClass() : null)));
            }
            Object item = anObject;
            if (anObject != null) {
                if (BeanFilterableComboBoxHandler.this.getBeanType().isInstance(anObject)) {
                    item = BeanFilterableComboBoxHandler.this.decorator.toString(anObject);
                    this.oldItem = anObject;
                }
                try {
                    this.wrapped.setItem(item);
                    this.getEditorComponent().setForeground(null);
                }
                catch (IllegalStateException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"setItem IllegalStateException ");
                    }
                    this.getEditorComponent().setForeground(BeanFilterableComboBoxHandler.this.ui.getInvalidComboEditorTextColor());
                }
            }
        }

        @Override
        public Object getItem() {
            JTextComponent editor = this.getEditorComponent();
            Object newValue = editor.getText();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getItem " + newValue + " - " + (newValue != null ? newValue.getClass() : null)));
            }
            if (this.oldItem != null && BeanFilterableComboBoxHandler.this.getBeanType().isInstance(this.oldItem) && newValue.equals(BeanFilterableComboBoxHandler.this.decorator.toString(this.oldItem))) {
                newValue = this.oldItem;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getItem 2 " + newValue + " - " + (newValue != null ? newValue.getClass() : null)));
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.wrapped.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.wrapped.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.wrapped.removeActionListener(l);
        }
    }
}

