/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.sample;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.sample.SampleImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.Unit;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Sample
implements Serializable {
    private static final long serialVersionUID = -4679812335657343627L;
    private Integer id;
    private String label;
    private Date sampleDate;
    private Short individualCount;
    private Float size;
    private String synchronizationStatus;
    private String comments;
    private Date creationDate;
    private Date controlDate;
    private Date validationDate;
    private Date qualificationDate;
    private String qualificationComments;
    private Timestamp updateDate;
    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();
    private FishingOperation fishingOperation;
    private Matrix matrix;
    private Department recorderDepartment;
    private Program program;
    private Sample parentSample;
    private Collection<Sample> childSamples = new HashSet<Sample>();
    private ReferenceTaxon referenceTaxon;
    private TaxonGroup taxonGroup;
    private QualityFlag qualityFlag;
    private Person recorderPerson;
    private Unit sizeUnit;
    private Batch batch;
    private Collection<SampleMeasurement> sampleMeasurements = new HashSet<SampleMeasurement>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getSampleDate() {
        return this.sampleDate;
    }

    public void setSampleDate(Date sampleDate) {
        this.sampleDate = sampleDate;
    }

    public Short getIndividualCount() {
        return this.individualCount;
    }

    public void setIndividualCount(Short individualCount) {
        this.individualCount = individualCount;
    }

    public Float getSize() {
        return this.size;
    }

    public void setSize(Float size) {
        this.size = size;
    }

    public String getSynchronizationStatus() {
        return this.synchronizationStatus;
    }

    public void setSynchronizationStatus(String synchronizationStatus) {
        this.synchronizationStatus = synchronizationStatus;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getControlDate() {
        return this.controlDate;
    }

    public void setControlDate(Date controlDate) {
        this.controlDate = controlDate;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public Date getQualificationDate() {
        return this.qualificationDate;
    }

    public void setQualificationDate(Date qualificationDate) {
        this.qualificationDate = qualificationDate;
    }

    public String getQualificationComments() {
        return this.qualificationComments;
    }

    public void setQualificationComments(String qualificationComments) {
        this.qualificationComments = qualificationComments;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Collection<FishingArea> getFishingAreas() {
        return this.fishingAreas;
    }

    public void setFishingAreas(Collection<FishingArea> fishingAreas) {
        this.fishingAreas = fishingAreas;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public Department getRecorderDepartment() {
        return this.recorderDepartment;
    }

    public void setRecorderDepartment(Department recorderDepartment) {
        this.recorderDepartment = recorderDepartment;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Sample getParentSample() {
        return this.parentSample;
    }

    public void setParentSample(Sample parentSample) {
        this.parentSample = parentSample;
    }

    public Collection<Sample> getChildSamples() {
        return this.childSamples;
    }

    public void setChildSamples(Collection<Sample> childSamples) {
        this.childSamples = childSamples;
    }

    public ReferenceTaxon getReferenceTaxon() {
        return this.referenceTaxon;
    }

    public void setReferenceTaxon(ReferenceTaxon referenceTaxon) {
        this.referenceTaxon = referenceTaxon;
    }

    public TaxonGroup getTaxonGroup() {
        return this.taxonGroup;
    }

    public void setTaxonGroup(TaxonGroup taxonGroup) {
        this.taxonGroup = taxonGroup;
    }

    public QualityFlag getQualityFlag() {
        return this.qualityFlag;
    }

    public void setQualityFlag(QualityFlag qualityFlag) {
        this.qualityFlag = qualityFlag;
    }

    public Person getRecorderPerson() {
        return this.recorderPerson;
    }

    public void setRecorderPerson(Person recorderPerson) {
        this.recorderPerson = recorderPerson;
    }

    public Unit getSizeUnit() {
        return this.sizeUnit;
    }

    public void setSizeUnit(Unit sizeUnit) {
        this.sizeUnit = sizeUnit;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public Collection<SampleMeasurement> getSampleMeasurements() {
        return this.sampleMeasurements;
    }

    public void setSampleMeasurements(Collection<SampleMeasurement> sampleMeasurements) {
        this.sampleMeasurements = sampleMeasurements;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sample)) {
            return false;
        }
        Sample that = (Sample)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Sample newInstance() {
            SampleImpl entity = new SampleImpl();
            return entity;
        }

        public static Sample newInstance(String label, String synchronizationStatus, Date creationDate, Matrix matrix, Department recorderDepartment, Program program, QualityFlag qualityFlag) {
            Sample entity = Factory.newInstance();
            entity.setLabel(label);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setMatrix(matrix);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        public static Sample newInstance(String label, Date sampleDate, Short individualCount, Float size, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Collection<FishingArea> fishingAreas, FishingOperation fishingOperation, Matrix matrix, Department recorderDepartment, Program program, Sample parentSample, Collection<Sample> childSamples, ReferenceTaxon referenceTaxon, TaxonGroup taxonGroup, QualityFlag qualityFlag, Person recorderPerson, Unit sizeUnit, Batch batch, Collection<SampleMeasurement> sampleMeasurements) {
            Sample entity = Factory.newInstance();
            entity.setLabel(label);
            entity.setSampleDate(sampleDate);
            entity.setIndividualCount(individualCount);
            entity.setSize(size);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setFishingAreas(fishingAreas);
            entity.setFishingOperation(fishingOperation);
            entity.setMatrix(matrix);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setParentSample(parentSample);
            entity.setChildSamples(childSamples);
            entity.setReferenceTaxon(referenceTaxon);
            entity.setTaxonGroup(taxonGroup);
            entity.setQualityFlag(qualityFlag);
            entity.setRecorderPerson(recorderPerson);
            entity.setSizeUnit(sizeUnit);
            entity.setBatch(batch);
            entity.setSampleMeasurements(sampleMeasurements);
            return entity;
        }
    }
}

