/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.config;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.ConfigCategoryUI;
import jaxx.runtime.swing.config.ConfigTableEditor;
import jaxx.runtime.swing.config.ConfigTableRenderer;
import jaxx.runtime.swing.config.model.ConfigTableModel;
import jaxx.runtime.swing.config.model.OptionModel;
import jaxx.runtime.swing.renderer.ClassTableCellRenderer;
import jaxx.runtime.swing.renderer.ColorCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ConfigCategoryUIHandler {
    private static final Log log = LogFactory.getLog(ConfigCategoryUIHandler.class);
    private final ConfigCategoryUI ui;

    public ConfigCategoryUIHandler(ConfigCategoryUI ui) {
        this.ui = ui;
    }

    public void init() {
        JTable table = this.ui.getTable();
        SwingUtil.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"config.key", (Object[])new Object[0]), I18n.n_((String)"config.key.tip", (Object[])new Object[0]), I18n.n_((String)"config.value", (Object[])new Object[0]), I18n.n_((String)"config.value.tip", (Object[])new Object[0]), I18n.n_((String)"config.defaultValue", (Object[])new Object[0]), I18n.n_((String)"config.defaultValue.tip", (Object[])new Object[0])});
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)renderer);
        SwingUtil.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)renderer);
        SwingUtil.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)renderer);
        Font f = table.getFont().deriveFont(3);
        int width = SwingUtil.computeTableColumnWidth((JTable)table, (Font)f, (int)0, (String)"___*");
        SwingUtil.fixTableColumnWidth((JTable)table, (int)0, (int)width);
        SwingUtil.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)new ConfigTableEditor((ConfigTableModel)table.getModel()));
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorCellRenderer());
        table.setDefaultRenderer(Class.class, (TableCellRenderer)new ClassTableCellRenderer());
    }

    public void updateDescriptionText() {
        OptionModel option;
        JTable table = this.ui.getTable();
        JTextArea description = this.ui.getDescription();
        ListSelectionModel selectionModel = this.ui.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel)table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug((Object)(row + " : " + option));
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(I18n._((String)"config.no.option.selected", (Object[])new Object[0]));
        } else {
            buffer.append(I18n._((String)"config.option.label", (Object[])new Object[]{option.getKey(), I18n._((String)option.getDescription(), (Object[])new Object[0])})).append('\n');
            if (option.isModified()) {
                buffer.append(I18n._((String)"config.option.modified", (Object[])new Object[]{option.getOriginalValue(), option.getValue()})).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(I18n._((String)"config.option.final", (Object[])new Object[0])).append('\n');
            }
        }
        description.setText(buffer.toString());
    }
}

