/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.synchro;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.ProgressionModel;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;

public class ReferentialSynchronizeResult {
    protected Exception error;
    protected final Map<String, Integer> rowHits = Maps.newTreeMap();
    protected final Map<String, Integer> insertHits = Maps.newTreeMap();
    protected final Map<String, Integer> updateHits = Maps.newTreeMap();
    protected final Map<String, Timestamp> updateDateHits = Maps.newTreeMap();
    protected final Set<String> tableNames = Sets.newHashSet();
    protected String localUrl;
    protected String remoteUrl;
    protected final ProgressionModel progressionModel = new ProgressionModel();

    public ReferentialSynchronizeResult() {
    }

    public ReferentialSynchronizeResult(String localUrl, String remoteUrl) {
        this.localUrl = localUrl;
        this.remoteUrl = remoteUrl;
    }

    public void setLocalUrl(String localUrl) {
        this.localUrl = localUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public ProgressionModel getProgressionModel() {
        return this.progressionModel;
    }

    public Set<String> getTableNames() {
        return ImmutableSet.copyOf(this.tableNames);
    }

    public int getTotalRows() {
        int result = 0;
        for (Integer nb : this.rowHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalInserts() {
        int result = 0;
        for (Integer nb : this.insertHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalUpdates() {
        int result = 0;
        for (Integer nb : this.updateHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getNbRows(String tableName) {
        Integer result = this.rowHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbInserts(String tableName) {
        Integer result = this.insertHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbUpdates(String tableName) {
        Integer result = this.updateHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public void addRows(String tableName, int nb) {
        if (nb > 0) {
            this.rowHits.put(tableName, this.getNbRows(tableName) + nb);
        }
    }

    public void addUpdates(String tableName, int nb) {
        if (nb > 0) {
            this.updateHits.put(tableName, this.getNbUpdates(tableName) + nb);
        }
    }

    public void addInserts(String tableName, int nb) {
        if (nb > 0) {
            this.insertHits.put(tableName, this.getNbInserts(tableName) + nb);
        }
    }

    public Timestamp getUpdateDate(String tableName) {
        return this.updateDateHits.get(tableName);
    }

    public void setUpdateDate(String tableName, Timestamp t) {
        this.updateDateHits.put(tableName, t);
    }

    public void addTableName(String tableName) {
        this.tableNames.add(tableName);
    }

    public String getLocalUrl() {
        return this.localUrl;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }
}

