/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.GearModel;
import fr.ifremer.tutti.service.referential.PersonModel;
import fr.ifremer.tutti.service.referential.SpeciesModel;
import fr.ifremer.tutti.service.referential.VesselModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.csv.Export;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.Import;
import org.nuiton.util.csv.ImportModel;

public class TuttiReferentialImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiReferentialImportExportService.class);
    protected PersistenceService persistenceService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Species> importTemporarySpecies(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import species from file: " + file));
        }
        HashSet existingSpeciesName = Sets.newHashSet((Iterable)Iterables.transform(this.persistenceService.getAllSpecies(), (Function)new Function<Species, String>(){

            public String apply(Species input) {
                return input.getName();
            }
        }));
        ArrayList toImport = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator(), existingSpeciesName);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (Species bean : importer) {
                    toImport.add(bean);
                }
                importer.close();
            }
            finally {
                Closeables.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (Exception e) {
            throw new IOException("Could not import species from file " + file, e);
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        List<Species> result = this.persistenceService.importTemporarySpecies(toImport);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Vessel> importTemporaryVessel(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import vessels from file: " + file));
        }
        HashSet existingVesselName = Sets.newHashSet((Iterable)Iterables.transform(this.persistenceService.getAllFishingVessel(), (Function)new Function<Vessel, String>(){

            public String apply(Vessel input) {
                return input.getName();
            }
        }));
        existingVesselName.addAll(Lists.transform(this.persistenceService.getAllScientificVessel(), (Function)new Function<Vessel, String>(){

            public String apply(Vessel input) {
                return input.getName();
            }
        }));
        ArrayList toImport = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            VesselModel csvModel = new VesselModel(this.getCsvSeparator(), existingVesselName);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (Vessel bean : importer) {
                    toImport.add(bean);
                }
                importer.close();
            }
            finally {
                Closeables.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (Exception e) {
            throw new IOException("Could not import vessels from file " + file, e);
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        List<Vessel> result = this.persistenceService.importTemporaryVessel(toImport);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> importTemporaryPerson(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import persons from file: " + file));
        }
        ArrayList toImport = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            PersonModel csvModel = new PersonModel(this.getCsvSeparator());
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (Person bean : importer) {
                    toImport.add(bean);
                }
                importer.close();
            }
            finally {
                Closeables.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (Exception e) {
            throw new IOException("Could not import persons from file " + file, e);
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        List<Person> result = this.persistenceService.importTemporaryPerson(toImport);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Gear> importTemporaryGear(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gears from file: " + file));
        }
        HashSet existingGearName = Sets.newHashSet((Iterable)Iterables.transform(this.persistenceService.getAllFishingGear(), (Function)new Function<Gear, String>(){

            public String apply(Gear input) {
                return input.getName();
            }
        }));
        existingGearName.addAll(Lists.transform(this.persistenceService.getAllScientificGear(), (Function)new Function<Gear, String>(){

            public String apply(Gear input) {
                return input.getName();
            }
        }));
        ArrayList toImport = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            GearModel csvModel = new GearModel(this.getCsvSeparator(), existingGearName);
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (Gear bean : importer) {
                    toImport.add(bean);
                }
                importer.close();
            }
            finally {
                Closeables.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (Exception e) {
            throw new IOException("Could not import gears from file " + file, e);
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        List<Gear> result = this.persistenceService.importTemporaryGear(toImport);
        return result;
    }

    public void exportTemporarySpeciesExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Species s = new Species();
        s.setName("Temporary Species name 1");
        toExport.add(s);
        s = new Species();
        s.setName("Temporary Species name 2");
        toExport.add(s);
        s = new Species();
        s.setName("Temporary Species name 3");
        toExport.add(s);
        SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator(), null);
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExport);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export species to file: " + file, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    public void exportTemporaryVesselExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Vessel v = new Vessel();
        v.setName("Temporary fishing vessel name 1");
        v.setInternationalRegistrationCode("International registration code F1");
        v.setScientificVessel(false);
        toExport.add(v);
        v = new Vessel();
        v.setName("Temporary fishing vessel name 2");
        v.setInternationalRegistrationCode("International registration code F2");
        v.setScientificVessel(false);
        toExport.add(v);
        v = new Vessel();
        v.setName("Temporary scientific vessel name 3");
        v.setInternationalRegistrationCode("International registration code S3");
        v.setScientificVessel(true);
        toExport.add(v);
        v = new Vessel();
        v.setName("Temporary scientific vessel name 4");
        v.setInternationalRegistrationCode("International registration code S4");
        v.setScientificVessel(true);
        toExport.add(v);
        VesselModel csvModel = new VesselModel(this.getCsvSeparator(), null);
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExport);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export species to file: " + file, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    public void exportTemporaryPersonExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Person p = new Person();
        p.setFirstName("First name 1");
        p.setLastName("Last name 1");
        toExport.add(p);
        p = new Person();
        p.setFirstName("First name 2");
        p.setLastName("Last name 2");
        toExport.add(p);
        p = new Person();
        p.setFirstName("First name 3");
        p.setLastName("Last name 3");
        toExport.add(p);
        PersonModel csvModel = new PersonModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExport);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export species to file: " + file, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    public void exportTemporaryGearExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Gear g = new Gear();
        g.setName("Gear fishing name 1");
        g.setLabel("Gear fishing label 1");
        toExport.add(g);
        g = new Gear();
        g.setName("Gear fishing name 2");
        g.setLabel("Gear fishing label 2");
        toExport.add(g);
        g = new Gear();
        g.setName("Gear scientific name 3");
        g.setLabel("Gear scientific label 3");
        g.setScientificGear(true);
        toExport.add(g);
        g = new Gear();
        g.setName("Gear scientific name 4");
        g.setLabel("Gear scientific label 4");
        g.setScientificGear(true);
        toExport.add(g);
        GearModel csvModel = new GearModel(this.getCsvSeparator(), null);
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExport);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export species to file: " + file, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

