package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id: AttachmentEditor.java 534 2013-03-05 10:45:23Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/attachment/AttachmentEditor.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Editor of attachment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.2
 */
public abstract class AttachmentEditor extends JDialog {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(AttachmentEditor.class);

    protected AttachmentEditorUI editor;

    protected JComponent component;

    public AttachmentEditor(Frame owner,
                            JComponent component,
                            AttachementObjectTypeEnum objectType,
                            String title) {
        super(owner, true);

        Preconditions.checkNotNull(
                component,
                "AttachmentEditor.component can not be null");
        this.component = component;
        this.editor = new AttachmentEditorUI();
        editor.setBorder(BorderFactory.createTitledBorder(title));
        editor.setObjectType(objectType);
        editor.setObjectIdProperty(AttachmentModelAware.PROPERTY_OBJECT_ID);

        setUndecorated(true);
        add(editor);
        setResizable(true);
        pack();

        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(this);
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(this);

        addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component) e.getSource();
                if (log.isInfoEnabled()) {
                    log.info("Destroy ui " + ui);
                }
                JAXXUtil.destroy(ui);
            }
        });

        component.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ENTER ||
                    e.getKeyCode() == KeyEvent.VK_SPACE) {
                    e.consume();
                    if (((JComponent) e.getSource()).isEnabled()) {
                        startEdit();
                    }
                }
            }
        });

        component.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                if (((JComponent) e.getSource()).isEnabled()) {
                    startEdit();
                }
            }
        });
    }

    protected abstract AttachmentModelAware getBean();

    public void startEdit() {

        editor.setBean(getBean());

        // Computes the location of bottom left corner of the cell
        Component comp = component;
        int x = 0;
        int y = component.getHeight();
        while (comp != null) {
            x += comp.getX();
            y += comp.getY();
            comp = comp.getParent();
        }

        pack();
        // if the editor is too big on the right,
        // then align its right side to the right side of the cell
        if (x + getWidth() > getOwner().getX() + getOwner().getWidth()) {
            x = x - getWidth() + component.getWidth();
        }
        setLocation(x, y);
        setVisible(true);
    }

    protected JComponent getComponent() {
        return component;
    }
}
