package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportProtocolCaracteristicAction.java 523 2013-03-03 20:22:36Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/ExportProtocolCaracteristicAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To import protocol caracteristics.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportProtocolCaracteristicAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportProtocolCaracteristicAction.class);

    private File file;

    public ExportProtocolCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler,
              "export",
              _("tutti.action.exportProtocolCaracteristic"),
              _("tutti.action.exportProtocolCaracteristic.tip"),
              true
        );
    }

    @Override
    protected boolean prepareAction() {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to export
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.title.choose.protocolCaracteristicExportFile"),
                    _("tutti.action.chooseProtocolCaracteristicFile"),
                    null,
                    "^.*\\.csv", _("tutti.file.csv")
            );
            if (file == null) {

                // user cancel
                doAction = false;
            } else {

                // add extension if missing
                file = TuttiIOUtil.addExtensionIfMissing(file, ".csv");
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will export protocol caracteristic to file: " + file);
        }

        // bind to a protocol
        TuttiProtocol protocol = getModel().toBean();

        // export protocol caracteristics
        TuttiProtocolImportExportService service =
                getContext().getTuttiProtocolImportExportService();

        service.exportProtocolCaracteristic(file,
                                            protocol,
                                            getModel().getAllCaracteristic());

        sendMessage(_("tutti.flash.information.caractristic.exported.from.protocol",
                      file));
    }
}