package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachmentEditor;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesBatchUI extends JPanel implements TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_MELAG_ENABLED = "createMelag.enabled";
    public static final String BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED = "createSpeciesBatchButton.enabled";
    public static final String BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED = "filterSpeciesBatchAllButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED = "filterSpeciesBatchLeafButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED = "filterSpeciesBatchRootButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT = "filterSpeciesBatchRootButton.text";
    public static final String BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED = "removeSpeciesBatchMenu.enabled";
    public static final String BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED = "removeSpeciesSubBatchMenu.enabled";
    public static final String BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED = "renameSpeciesBatchMenu.enabled";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL = "speciesTotalInertWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalInertWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL = "speciesTotalLivingNotItemizedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalLivingNotItemizedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";
    public static final String BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED = "splitSpeciesBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachmentEditor attachmentEditor;
    protected JButton attachmentsButton;
    protected JMenuItem createMelag;
    protected JButton createSpeciesBatchButton;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton filterSpeciesBatchAllButton;
    protected JLabel filterSpeciesBatchLabel;
    protected JRadioButton filterSpeciesBatchLeafButton;
    protected JAXXButtonGroup filterSpeciesBatchMode;
    protected JRadioButton filterSpeciesBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected SpeciesBatchUIHandler handler;
    protected SpeciesBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected SpeciesBatchUIModel model;
    protected JMenuItem removeSpeciesBatchMenu;
    protected JMenuItem removeSpeciesSubBatchMenu;
    protected JMenuItem renameSpeciesBatchMenu;
    protected NumberEditor speciesTotalInertWeightField;
    protected JLabel speciesTotalInertWeightLabel;
    protected NumberEditor speciesTotalLivingNotItemizedWeightField;
    protected JLabel speciesTotalLivingNotItemizedWeightLabel;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JMenuItem splitSpeciesBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SpeciesBatchUIHandler handler = new SpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createSpeciesBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createSpeciesBatch();
    }

    public void doActionPerformed__on__filterSpeciesBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterSpeciesBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterSpeciesBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__splitSpeciesBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitSpeciesBatch();
    }

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachmentEditor getAttachmentEditor() {
        return attachmentEditor;
    }

    public JButton getAttachmentsButton() {
        return attachmentsButton;
    }

    public JMenuItem getCreateMelag() {
        return createMelag;
    }

    public JButton getCreateSpeciesBatchButton() {
        return createSpeciesBatchButton;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFilterSpeciesBatchAllButton() {
        return filterSpeciesBatchAllButton;
    }

    public JLabel getFilterSpeciesBatchLabel() {
        return filterSpeciesBatchLabel;
    }

    public JRadioButton getFilterSpeciesBatchLeafButton() {
        return filterSpeciesBatchLeafButton;
    }

    public JAXXButtonGroup getFilterSpeciesBatchMode() {
        return filterSpeciesBatchMode;
    }

    public JRadioButton getFilterSpeciesBatchRootButton() {
        return filterSpeciesBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveSpeciesBatchMenu() {
        return removeSpeciesBatchMenu;
    }

    public JMenuItem getRemoveSpeciesSubBatchMenu() {
        return removeSpeciesSubBatchMenu;
    }

    public JMenuItem getRenameSpeciesBatchMenu() {
        return renameSpeciesBatchMenu;
    }

    public NumberEditor getSpeciesTotalInertWeightField() {
        return speciesTotalInertWeightField;
    }

    public JLabel getSpeciesTotalInertWeightLabel() {
        return speciesTotalInertWeightLabel;
    }

    public NumberEditor getSpeciesTotalLivingNotItemizedWeightField() {
        return speciesTotalLivingNotItemizedWeightField;
    }

    public JLabel getSpeciesTotalLivingNotItemizedWeightLabel() {
        return speciesTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JMenuItem getSplitSpeciesBatchMenu() {
        return splitSpeciesBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFilterSpeciesBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchAllButton); }
    }

    protected void addChildrenToFilterSpeciesBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchLeafButton); }
    }

    protected void addChildrenToFilterSpeciesBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterSpeciesBatchLabel);
        filterTablePane.add(filterSpeciesBatchAllButton);
        filterTablePane.add(filterSpeciesBatchLeafButton);
        filterTablePane.add(filterSpeciesBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitSpeciesBatchMenu);
        tablePopup.add(removeSpeciesBatchMenu);
        tablePopup.add(removeSpeciesSubBatchMenu);
        tablePopup.add(renameSpeciesBatchMenu);
        tablePopup.add(createMelag);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add(filterTablePane, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = ButtonAttachmentEditor.newEditor(this, attachmentsButton));
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new JButton());
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createCreateMelag() {
        $objectMap.put("createMelag", createMelag = new JMenuItem());
        
        createMelag.setName("createMelag");
        createMelag.putClientProperty("tuttiAction", CreateMelagAction.class);
    }

    protected void createCreateSpeciesBatchButton() {
        $objectMap.put("createSpeciesBatchButton", createSpeciesBatchButton = new JButton());
        
        createSpeciesBatchButton.setName("createSpeciesBatchButton");
        createSpeciesBatchButton.setText(_("tutti.action.createSpeciesBatch"));
        createSpeciesBatchButton.setMnemonic(67);
        createSpeciesBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createSpeciesBatchButton"));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFilterSpeciesBatchAllButton() {
        $objectMap.put("filterSpeciesBatchAllButton", filterSpeciesBatchAllButton = new JRadioButton());
        
        filterSpeciesBatchAllButton.setName("filterSpeciesBatchAllButton");
        filterSpeciesBatchAllButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.all"));
        { filterSpeciesBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSpeciesBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchAllButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.all.tip"));
        filterSpeciesBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchAllButton"));
    }

    protected void createFilterSpeciesBatchLabel() {
        $objectMap.put("filterSpeciesBatchLabel", filterSpeciesBatchLabel = new JLabel());
        
        filterSpeciesBatchLabel.setName("filterSpeciesBatchLabel");
        filterSpeciesBatchLabel.setText(_("tutti.label.filterSpeciesBatchMode.label"));
        filterSpeciesBatchLabel.setToolTipText(_("tutti.label.filterSpeciesBatchMode.label.tip"));
        filterSpeciesBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSpeciesBatchLeafButton() {
        $objectMap.put("filterSpeciesBatchLeafButton", filterSpeciesBatchLeafButton = new JRadioButton());
        
        filterSpeciesBatchLeafButton.setName("filterSpeciesBatchLeafButton");
        filterSpeciesBatchLeafButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.leaf"));
        { filterSpeciesBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterSpeciesBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchLeafButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.leaf.tip"));
        filterSpeciesBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchLeafButton"));
    }

    protected void createFilterSpeciesBatchMode() {
        $objectMap.put("filterSpeciesBatchMode", filterSpeciesBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterSpeciesBatchRootButton() {
        $objectMap.put("filterSpeciesBatchRootButton", filterSpeciesBatchRootButton = new JRadioButton());
        
        filterSpeciesBatchRootButton.setName("filterSpeciesBatchRootButton");
        { filterSpeciesBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterSpeciesBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchRootButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.root.tip"));
        filterSpeciesBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createRemoveSpeciesBatchMenu() {
        $objectMap.put("removeSpeciesBatchMenu", removeSpeciesBatchMenu = new JMenuItem());
        
        removeSpeciesBatchMenu.setName("removeSpeciesBatchMenu");
        removeSpeciesBatchMenu.setMnemonic(82);
        removeSpeciesBatchMenu.putClientProperty("tuttiAction", RemoveSpeciesBatchAction.class);
    }

    protected void createRemoveSpeciesSubBatchMenu() {
        $objectMap.put("removeSpeciesSubBatchMenu", removeSpeciesSubBatchMenu = new JMenuItem());
        
        removeSpeciesSubBatchMenu.setName("removeSpeciesSubBatchMenu");
        removeSpeciesSubBatchMenu.setMnemonic(82);
        removeSpeciesSubBatchMenu.putClientProperty("tuttiAction", RemoveSpeciesSubBatchAction.class);
    }

    protected void createRenameSpeciesBatchMenu() {
        $objectMap.put("renameSpeciesBatchMenu", renameSpeciesBatchMenu = new JMenuItem());
        
        renameSpeciesBatchMenu.setName("renameSpeciesBatchMenu");
        renameSpeciesBatchMenu.putClientProperty("tuttiAction", RenameSpeciesBatchAction.class);
    }

    protected void createSpeciesTotalInertWeightField() {
        $objectMap.put("speciesTotalInertWeightField", speciesTotalInertWeightField = new NumberEditor(this));
        
        speciesTotalInertWeightField.setName("speciesTotalInertWeightField");
        speciesTotalInertWeightField.setProperty("speciesTotalInertWeight");
        speciesTotalInertWeightField.setUseFloat(true);
        speciesTotalInertWeightField.setShowReset(false);
    }

    protected void createSpeciesTotalInertWeightLabel() {
        $objectMap.put("speciesTotalInertWeightLabel", speciesTotalInertWeightLabel = new JLabel());
        
        speciesTotalInertWeightLabel.setName("speciesTotalInertWeightLabel");
        speciesTotalInertWeightLabel.setText(_("tutti.label.catches.speciesTotalInertWeight"));
    }

    protected void createSpeciesTotalLivingNotItemizedWeightField() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightField", speciesTotalLivingNotItemizedWeightField = new NumberEditor(this));
        
        speciesTotalLivingNotItemizedWeightField.setName("speciesTotalLivingNotItemizedWeightField");
        speciesTotalLivingNotItemizedWeightField.setProperty("speciesTotalLivingNotItemizedWeight");
        speciesTotalLivingNotItemizedWeightField.setUseFloat(true);
        speciesTotalLivingNotItemizedWeightField.setShowReset(false);
    }

    protected void createSpeciesTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightLabel", speciesTotalLivingNotItemizedWeightLabel = new JLabel());
        
        speciesTotalLivingNotItemizedWeightLabel.setName("speciesTotalLivingNotItemizedWeightLabel");
        speciesTotalLivingNotItemizedWeightLabel.setText(_("tutti.label.catches.speciesTotalLivingNotItemizedWeight"));
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSampleSortedWeight"));
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setDecimalNumber(3);
        speciesTotalSortedWeightField.setUseFloat(true);
        speciesTotalSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSortedWeight"));
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.label.catches.speciesTotalUnsortedWeight"));
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.label.catches.speciesTotalWeight"));
    }

    protected void createSplitSpeciesBatchMenu() {
        $objectMap.put("splitSpeciesBatchMenu", splitSpeciesBatchMenu = new JMenuItem());
        
        splitSpeciesBatchMenu.setName("splitSpeciesBatchMenu");
        splitSpeciesBatchMenu.setText(_("tutti.action.splitSpeciesBatch"));
        splitSpeciesBatchMenu.setMnemonic(83);
        splitSpeciesBatchMenu.setToolTipText(_("tutti.action.splitSpeciesBatch.tip"));
        splitSpeciesBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitSpeciesBatchMenu"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createSpeciesBatchButton);
        $JPanel0.add(attachmentsButton);
        addChildrenToFilterTablePane();
        addChildrenToFilterSpeciesBatchAllButton();
        addChildrenToFilterSpeciesBatchLeafButton();
        addChildrenToFilterSpeciesBatchRootButton();
        addChildrenToTableScrollPane();
        
        // apply 20 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        splitSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalInertWeightLabel.setLabelFor(speciesTotalInertWeightField);
        speciesTotalInertWeightField.setBean(model);
        speciesTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalLivingNotItemizedWeightLabel.setLabelFor(speciesTotalLivingNotItemizedWeightField);
        speciesTotalLivingNotItemizedWeightField.setBean(model);
        speciesTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterSpeciesBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        attachmentEditor.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createLongTextEditor();
        createTablePopup();
        createSplitSpeciesBatchMenu();
        createRemoveSpeciesBatchMenu();
        createRemoveSpeciesSubBatchMenu();
        createRenameSpeciesBatchMenu();
        createCreateMelag();
        createForm();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createSpeciesTotalInertWeightLabel();
        createSpeciesTotalInertWeightField();
        createSpeciesTotalLivingNotItemizedWeightLabel();
        createSpeciesTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateSpeciesBatchButton();
        createAttachmentsButton();
        createFilterTablePane();
        createFilterSpeciesBatchLabel();
        createFilterSpeciesBatchAllButton();
        createFilterSpeciesBatchLeafButton();
        createFilterSpeciesBatchRootButton();
        createTableScrollPane();
        createTable();
        createAttachmentEditor();
        createFilterSpeciesBatchMode();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 20 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 20 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSpeciesSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_MELAG_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createMelag.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, getWeightStringValue(model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, getWeightStringValue(model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getWeightStringValue(model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setModel(model.getSpeciesTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalInertWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setModel(model.getSpeciesTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalLivingNotItemizedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesBatchButton.setEnabled(model.isCreateSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setText(_(handler.getFilterSpeciesBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
    }

}