/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.spatial;

public class GeoPositionHelper {
    public static Integer getQuadrant(Float longitude, Float latitude) {
        if (longitude == null || latitude == null) {
            return null;
        }
        int result = latitude.floatValue() > 0.0f ? (longitude.floatValue() > 0.0f ? 1 : 4) : (longitude.floatValue() > 0.0f ? 2 : 3);
        return result;
    }

    public static Float getSignedLongitude(Integer quadrant, Float longitude) {
        int result;
        if (longitude == null) {
            return null;
        }
        if (quadrant == null) {
            return longitude;
        }
        switch (quadrant) {
            case 1: 
            case 2: {
                result = 1;
                break;
            }
            default: {
                result = -1;
            }
        }
        return Float.valueOf((float)result * longitude.floatValue());
    }

    public static Float getSignedLatitude(Integer quadrant, Float latitude) {
        int result;
        if (latitude == null) {
            return null;
        }
        if (quadrant == null) {
            return latitude;
        }
        switch (quadrant) {
            case 1: 
            case 4: {
                result = 1;
                break;
            }
            default: {
                result = -1;
            }
        }
        return Float.valueOf((float)result * latitude.floatValue());
    }
}

