/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;

public class Export<E> {
    private static final Log log = LogFactory.getLog(Export.class);
    protected final ExportModel<E> model;
    protected Iterable<E> data;
    protected final String separator;

    public static <E> Export<E> newExport(ExportModel<E> model, Iterable<E> data) {
        return new Export<E>(model, data);
    }

    public static <E> void exportToWriter(ExportModel<E> model, Iterable<E> data, Writer writer) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.write(writer);
    }

    public static <E> void exportToFile(ExportModel<E> model, Iterable<E> data, File file) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.write(file);
    }

    public static <E> void exportToFile(ExportModel<E> model, Iterable<E> data, File file, Charset charset) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.write(file, charset);
    }

    public static <E> String exportToString(ExportModel<E> model, Iterable<E> data) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        return exporter.toString(Charset.defaultCharset());
    }

    public static <E> String exportToString(ExportModel<E> model, Iterable<E> data, Charset charset) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        return exporter.toString(charset);
    }

    protected Export(ExportModel<E> model, Iterable<E> data) {
        this.model = model;
        this.data = data;
        this.separator = String.valueOf(model.getSeparator());
    }

    public void write(Writer writer) throws Exception {
        this.writeHeader(writer);
        Iterable<ExportableColumn<E, Object>> columns = this.model.getColumnsForExport();
        for (E row : this.data) {
            this.writeRow(writer, columns, row);
        }
    }

    protected void writeHeader(Writer writer) throws IOException {
        LinkedList<String> headerNames = new LinkedList<String>();
        for (ExportableColumn<E, Object> column : this.model.getColumnsForExport()) {
            headerNames.add(column.getHeaderName());
        }
        String headersLine = StringUtil.join(headerNames, (String)this.separator, (boolean)true);
        writer.write(headersLine);
        writer.write(10);
        if (log.isDebugEnabled()) {
            log.debug((Object)("headers for export are '" + headersLine + "'"));
            if (this.data instanceof Collection) {
                log.debug((Object)("will export " + ((Collection)this.data).size() + " lines"));
            }
        }
    }

    protected void writeRow(Writer writer, Iterable<ExportableColumn<E, Object>> columns, E row) throws Exception {
        for (ExportableColumn<E, Object> column : columns) {
            Object cell;
            String formattedCell = column.formatValue(cell = column.getValue(row));
            if (formattedCell == null) {
                throw new NullPointerException("column for header " + column.getHeaderName() + " returned a null value." + column.toString());
            }
            formattedCell = StringUtil.escapeCsvValue((String)formattedCell, (String)this.separator);
            writer.write(formattedCell);
            writer.write(this.separator);
        }
        writer.write(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, Charset charset) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        try {
            this.write(writer);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public void write(OutputStream outputStream) throws Exception {
        this.write(outputStream, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Charset charset) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.write(fileOutputStream, charset);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void write(File file) throws Exception {
        this.write(file, Charset.defaultCharset());
    }

    public String toString(Charset charset) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.write(outputStream, charset);
        byte[] bytes = outputStream.toByteArray();
        String result = new String(bytes, charset);
        return result;
    }

    @Deprecated
    public void exportToFile(File file) throws Exception {
        this.write(file);
    }

    @Deprecated
    public void startExport(Writer writer) throws Exception {
        this.write(writer);
    }

    @Deprecated
    public String startExportAsString() throws Exception {
        return this.toString(Charset.defaultCharset());
    }

    @Deprecated
    public InputStream startExport() throws Exception {
        String content = this.toString(Charset.defaultCharset());
        return IOUtils.toInputStream((String)content);
    }
}

