package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: ActionListCellRenderer.java 308 2013-02-03 13:06:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/ActionListCellRenderer.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import java.awt.Component;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ActionListCellRenderer extends DefaultListCellRenderer {

    private static final long serialVersionUID = 1L;

    protected final EmptyBorder border = new EmptyBorder(4, 8, 4, 8);

    @Override
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {
        Component result = super.getListCellRendererComponent(
                list, value, index, isSelected, cellHasFocus);
        Action action = (Action) value;
        setIcon((Icon) action.getValue(Action.LARGE_ICON_KEY));
        setText((String) action.getValue(Action.NAME));
        setToolTipText((String) action.getValue(Action.SHORT_DESCRIPTION));
        setBorder(border);
        return result;
    }
}
