package fr.ifremer.tutti.ui.swing.content.operation.fishing.environment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class EnvironmentTabUI extends Table implements TuttiUI<EnvironmentTabUIModel, EnvironmentTabUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_NEW_ROW_KEY_ENABLED = "newRowKey.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED = "removeCaracteristicMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vz28bRRQeO7ETpwm0jZqmakEOFNQIdUzFBSn8aGwc6tRJIzsVUX2AsXdsTzqeWWbfxmtZRfwJ/Alw54LEjRPiwJkDF8S/gBAHrog3u7bXrrdKDt3DaDXzfnzvzfu++f4vkvEM2TplQUCNr0D0ON3fPTl51DzlLfiEey0jXNCGRF8qTdINcsmZ7HtA3mxUrXth5F4o6Z6rFVdT3jtVsuLBQHKvyzkAeW3Wo+V5hfrkeCdwfTOOOgGVFPXbf/5Of+N8/V2akMBFdDksJX+eV1zJYpWkhQPkKmY6YwXJVAdhGKE6iHfN7pUk87xD1uNfkq/IUpVkXWYwGJA3Ll5yGCP0D1wgS7ePWVPyd4EctQ0VbcN73FDwAQT1BfX6mJ22tAIMRrXLDQOhFW0Lr2tPuDoTRquePS3H/xjzccV1wzRZTNJlypHcAPnsZSd5EEWOc2V62uESyOOXnenAxo3zrIDt25F2fezihr2cYBR+P9w84MqPra8jEH3GS8ywFnAjPBAtawHk2oyr3asA71m3qxPvnOL9mu4/5AMg78zMU+TGHYE3TJucKVrEBa+/qYs6sO65SZQscxyMAmR9JmURm6PVrOna7f16y2gpj5iys3F9xiM+mvW6zGdaJjmQm9p06CnS8yloN/IP6P5JeGq9XneRIjdnSkLy0Zh8MTtSDZIxPm4D2WzM87WGRxFTN59jqg0Ynv63sf77T3/+uDem5xLmvpZoOqUuSBvX2EkBYVO/GnHTByELB8zdaSDJuURpCqXnVgKw+ugYwWG+K9adWnf6gHldDJFZ+uPnXza++G2BpPfIitTM2WPWvkJy0DXYBS2dwP34fohotb+M62WLDUdQ3HtfHRneFgECi4Z8hHVAA+zErYROTOA0c7/+u17/4f64GylEd+OF5nFHMk9IVigpFA/laqREifJ0yfW47+hYcZI0iCB/VqendsSa7XC9O1f4AuoJV3aAUCo3hlsTblDhlXsuDO5sPwOyPG4EMiy6IO7MsA9Zha3t17hnH4BMm0mPB75NeS9shv17j0xzzz0HWHoa2FvDGFeHQ30EwXL7znZ+68O88qVEnCuICBWoYjWJLCBDkzCMmHsegEUkblQrRrRyZWFUsdr69Kak9crhp9Xy5/VytVw6rjw6tO3ytIGIslErUCUmofa04R2jfYV1rQ1LWqLWFKu7pYfPpq2KrPV0bJUdhuUl1TInEudVhYOekaxpNX0zmnEQIDltMmh1d8PUXlKiKYG+QOPim3t7GL4gOE21ec0uR1bhiC0CD3B08hGo6B5pgs5jd3sKt5X9TdWeu/PVsI67mJFD4gC+6Om4QN+W7YtwPHDxNl/5wGHA8k2hHNTgj+YSpex6A2P+DzyQkheCCQAA";
    private static final Log log = LogFactory.getLog(EnvironmentTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected JXTable environmentTable;
    protected EnvironmentTabUIHandler handler;
    protected EnvironmentTabUIModel model;
    protected BeanComboBox<Caracteristic> newRowKey;
    protected JMenuItem removeCaracteristicMenu;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private EnvironmentTabUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI(); 
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EnvironmentTabUI(EditFishingOperationUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EnvironmentTabUIHandler handler = new EnvironmentTabUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EnvironmentTabUI() {
        $initialize();
    }

    public EnvironmentTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRow(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addRow();
    }

    public void doActionPerformed__on__removeCaracteristicMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeCaracteristic();
    }

    public void doMouseClicked__on__environmentTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public JXTable getEnvironmentTable() {
        return environmentTable;
    }

    public EnvironmentTabUIHandler getHandler() {
        return handler;
    }

    public EnvironmentTabUIModel getModel() {
        return model;
    }

    public BeanComboBox<Caracteristic> getNewRowKey() {
        return newRowKey;
    }

    public JMenuItem getRemoveCaracteristicMenu() {
        return removeCaracteristicMenu;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeCaracteristicMenu);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRow"));
    }

    protected void createEnvironmentTable() {
        $objectMap.put("environmentTable", environmentTable = new JXTable());
        
        environmentTable.setName("environmentTable");
        environmentTable.setSortable(false);
        environmentTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__environmentTable"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EnvironmentTabUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EnvironmentTabUIModel.class));
    }

    protected void createNewRowKey() {
        $objectMap.put("newRowKey", newRowKey = new BeanComboBox<Caracteristic>(this));
        
        newRowKey.setName("newRowKey");
        newRowKey.setI18nPrefix("tutti.property.");
        newRowKey.setProperty("selectedCaracteristic");
        newRowKey.setShowReset(false);
    }

    protected void createRemoveCaracteristicMenu() {
        $objectMap.put("removeCaracteristicMenu", removeCaracteristicMenu = new JMenuItem());
        
        removeCaracteristicMenu.setName("removeCaracteristicMenu");
        removeCaracteristicMenu.setText(_("tutti.action.removeCaracteristic"));
        removeCaracteristicMenu.setMnemonic(82);
        removeCaracteristicMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeCaracteristicMenu"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(newRowKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTablePopup();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(environmentTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        newRowKey.setBeanType(Caracteristic.class);
        removeCaracteristicMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        environmentTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        environmentTable.setSelectionForeground(Color.BLACK);
        environmentTable.setSelectionBackground(null);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createModel();
        createTablePopup();
        createRemoveCaracteristicMenu();
        createNewRowKey();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createEnvironmentTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMenu.setEnabled(model.isRemoveCaracteristicEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    newRowKey.setEnabled(!newRowKey.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    addRow.setEnabled(newRowKey.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}