
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: AddSpeciesAction.java 456 2013-02-22 18:11:12Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/split/AddSpeciesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * Enable to select a species to the species selected in the protocol.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class AddSpeciesAction extends AbstractTuttiAction<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI, CreateSpeciesBatchUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(AddSpeciesAction.class);

    protected List<Species> allSpecies;
    
    protected List<Species> referentSpecies;

    protected Species selectedSpecies;

    public AddSpeciesAction(CreateSpeciesBatchUIHandler handler) {
        super(handler,
              "addSpecies",
              null,
              _("tutti.action.addSpecies.text"),
              _("tutti.action.addSpecies.tip"),
              false
        );

        TuttiPersistence persistenceService = getContext().getService(PersistenceService.class);
        allSpecies = persistenceService.getAllSpecies();
        referentSpecies = persistenceService.getAllReferentSpecies();
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);

        List<Species> availableSpecies = getModel().getAvailableSpecies();
        List<Species> species = Lists.newArrayList(allSpecies);
        species.removeAll(availableSpecies);

        selectedSpecies = getHandler().openAddSpeciesDialog(_("tutti.title.selectSpecies"), species);

        result &= selectedSpecies != null;
        return result;
    }

    @Override
    protected void doAction(ActionEvent event) {
        CreateSpeciesBatchUIModel model = getModel();

        if (!selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = decorate(selectedSpecies);
            List<Species> referents = referentSpecies;
            Map<String, Species> referentsById = TuttiEntities.splitByTaxonId(referents);
            String taxonId = String.valueOf(selectedSpecies.getReferenceTaxonId());
            selectedSpecies = referentsById.get(taxonId);
            String decoratedReferent = decorate(selectedSpecies);
            sendMessage(_("tutti.flash.information.species.replaced", decoratedSynonym, decoratedReferent));
        }
        
        List<Species> availableSpecies = Lists.newArrayList(model.getAvailableSpecies());
        if (!availableSpecies.contains(selectedSpecies)) {
            availableSpecies.add(selectedSpecies);
        }
        model.setAvailableSpecies(availableSpecies);
        model.setSpecies(selectedSpecies);
    }

}
