package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportDbAction.java 421 2013-02-15 14:49:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/ExportDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * To export a db attached to Tutti.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportDbAction extends AbstractMainUITuttiAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ExportDbAction.class);

    public ExportDbAction(MainUIHandler handler) {
        super(handler,
              "exportDb",
              "export-db",
              _("tutti.action.exportDb"),
              _("tutti.action.exportDb.tip"),
              true);
    }

    @Override
    protected void doAction(ActionEvent event) {

        if (log.isInfoEnabled()) {
            log.info("Will export db...");
        }

        //TODO
    }
}