/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.io.Serializable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TableRowModificationListener<R extends Serializable>
implements ListSelectionListener {
    private static final Log log = LogFactory.getLog(TableRowModificationListener.class);
    private final AbstractTuttiTableModel<R> tableModel;
    private final TuttiBeanMonitor<R> beanMonitor;

    protected abstract void saveSelectedRow();

    public TableRowModificationListener(AbstractTuttiTableModel<R> tableModel, TuttiBeanMonitor<R> beanMonitor) {
        this.tableModel = tableModel;
        this.beanMonitor = beanMonitor;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object entry;
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            int selectedRow = source.getLeadSelectionIndex();
            this.saveSelectedRow();
            if (source.isSelectionEmpty()) {
                entry = null;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Selection is now empty.");
                }
            } else {
                entry = this.tableModel.getEntry(selectedRow);
                if (log.isInfoEnabled()) {
                    log.info((Object)("New selected row: " + selectedRow));
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Will monitor entry: " + entry));
            }
            this.beanMonitor.setBean(entry);
        }
    }
}

