/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import fr.ifremer.tutti.ui.swing.util.table.MoveToNextEditableCellAction;
import fr.ifremer.tutti.ui.swing.util.table.MoveToNextEditableRowAction;
import fr.ifremer.tutti.ui.swing.util.table.MoveToPreviousEditableCellAction;
import fr.ifremer.tutti.ui.swing.util.table.MoveToPreviousEditableRowAction;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public abstract class AbstractTuttiTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiTableUIModel<?, R, M>>
extends AbstractTuttiUIHandler<M> {
    private static final Log log = LogFactory.getLog(AbstractTuttiTableUIHandler.class);
    private final TuttiBeanMonitor<R> rowMonitor;

    protected abstract JXTable getTable();

    protected abstract AbstractTuttiTableModel<R> getTableModel();

    protected abstract TableColumnModel createTableColumnModel();

    protected abstract void onRowModified(R var1, String var2, Object var3, Object var4);

    protected abstract void onRowValidStateChanged(R var1, Boolean var2, Boolean var3);

    protected abstract void onRowModifyStateChanged(R var1, Boolean var2, Boolean var3);

    protected String[] getRowPropertiesToIgnore() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    protected AbstractTuttiTableUIHandler(TuttiUIContext context, String ... properties) {
        super(context);
        this.rowMonitor = new TuttiBeanMonitor(properties);
        this.rowMonitor.addPropertyChangeListener("bean", new PropertyChangeListener(){
            final Set<String> propertiesToSkip;
            final PropertyChangeListener l;
            {
                this.propertiesToSkip = Sets.newHashSet((Object[])AbstractTuttiTableUIHandler.this.getRowPropertiesToIgnore());
                this.l = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        String propertyName = evt.getPropertyName();
                        AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)((Object)evt.getSource());
                        Object oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        if ("valid".equals(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowValidStateChanged(row, (Boolean)oldValue, (Boolean)newValue);
                        } else if ("modify".equals(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowModifyStateChanged(row, (Boolean)oldValue, (Boolean)newValue);
                        } else if (!propertiesToSkip.contains(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowModified(row, propertyName, oldValue, newValue);
                        }
                    }
                };
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiBeanUIModel oldValue = (AbstractTuttiBeanUIModel)((Object)evt.getOldValue());
                AbstractTuttiBeanUIModel newValue = (AbstractTuttiBeanUIModel)((Object)evt.getNewValue());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Monitor row changed from " + (Object)((Object)oldValue) + " to " + (Object)((Object)newValue)));
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(this.l);
                }
                if (newValue != null) {
                    newValue.addPropertyChangeListener(this.l);
                }
            }
        });
    }

    protected KeyListener installTableKeyListener(TableColumnModel columnModel, JTable table) {
        AbstractTuttiTableModel<R> model = this.getTableModel();
        final MoveToNextEditableCellAction<AbstractTuttiTableModel<R>> nextCellAction = MoveToNextEditableCellAction.newAction(model, table);
        final MoveToPreviousEditableCellAction<AbstractTuttiTableModel<R>> previousCellAction = MoveToPreviousEditableCellAction.newAction(model, table);
        final MoveToNextEditableRowAction<AbstractTuttiTableModel<R>> nextRowAction = MoveToNextEditableRowAction.newAction(model, table);
        final MoveToPreviousEditableRowAction<AbstractTuttiTableModel<R>> previousRowAction = MoveToPreviousEditableRowAction.newAction(model, table);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 39 || e.getKeyCode() == 9) {
                    e.consume();
                    nextCellAction.actionPerformed(null);
                } else if (e.getKeyCode() == 37) {
                    e.consume();
                    previousCellAction.actionPerformed(null);
                } else if (e.getKeyCode() == 38) {
                    e.consume();
                    previousRowAction.actionPerformed(null);
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                    nextRowAction.actionPerformed(null);
                }
            }
        };
        table.addKeyListener(keyAdapter);
        Enumeration<TableColumn> columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = columns.nextElement();
            TableCellEditor cellEditor = tableColumn.getCellEditor();
            if (!(cellEditor instanceof NumberCellEditor)) continue;
            NumberCellEditor editor = (NumberCellEditor)cellEditor;
            editor.getNumberEditor().getTextField().addKeyListener(keyAdapter);
        }
        return keyAdapter;
    }

    protected void addColumnToModel(TableColumnModel model, TableCellEditor editor, TableCellRenderer renderer, ColumnIdentifier<R> identifier) {
        TableColumnExt col = new TableColumnExt(model.getColumnCount());
        col.setCellEditor(editor);
        col.setCellRenderer(renderer);
        col.setHeaderValue(I18n._((String)identifier.getHeaderI18nKey(), (Object[])new Object[0]));
        col.setIdentifier(identifier);
        model.addColumn((TableColumn)col);
    }

    protected void addColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier) {
        this.addColumnToModel(model, null, null, identifier);
    }

    protected void addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        this.addColumnToModel(model, (TableCellEditor)editor, null, identifier);
    }

    protected void addIntegerColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Integer.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        this.addColumnToModel(model, (TableCellEditor)editor, null, identifier);
    }

    protected void addBooleanColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, JTable table) {
        this.addColumnToModel(model, table.getDefaultEditor(Boolean.class), table.getDefaultRenderer(Boolean.class), identifier);
    }

    protected <B> void addComboDataColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, Decorator<B> decorator, List<B> data) {
        JComboBox comboBox = new JComboBox();
        comboBox.setRenderer(this.newListCellRender(decorator));
        if (!data.isEmpty() && data.get(0) != null) {
            data.add(0, null);
        }
        SwingUtil.fillComboBox(comboBox, data, null);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), identifier);
    }

    protected void listenRowsFromModel() {
        ((AbstractTuttiTableUIModel)((Object)this.getModel())).addPropertyChangeListener("rows", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiTableUIHandler.this.onModelRowsChanged((List)evt.getNewValue());
            }
        });
    }

    protected void onModelRowsChanged(List<R> rows) {
        this.getTableModel().setRows(rows);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type) {
        return this.newTableCellRender(type, null);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        TableCellRenderer result = this.newTableCellRender(decorator);
        return result;
    }

    protected <O> TableCellRenderer newTableCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorTableCellRenderer result = new DecoratorTableCellRenderer(decorator);
        return result;
    }

    protected TuttiBeanMonitor<R> getRowMonitor() {
        return this.rowMonitor;
    }
}

