/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTuttiTableModel<R extends Serializable>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractTuttiTableModel.class);
    protected final TableColumn[] columns;
    protected final List<ColumnIdentifier<R>> columnIdentifiers;
    protected List<R> rows;
    protected Set<ColumnIdentifier<?>> noneEditableCols;

    protected abstract R createNewRow();

    protected AbstractTuttiTableModel(TableColumnModel columnModel) {
        int nbcols = columnModel.getColumnCount();
        this.columns = new TableColumn[nbcols];
        this.columnIdentifiers = Lists.newArrayList();
        for (int i = 0; i < nbcols; ++i) {
            TableColumn column;
            this.columns[i] = column = columnModel.getColumn(i);
            this.columnIdentifiers.add((ColumnIdentifier)column.getIdentifier());
        }
    }

    public final List<R> getRows() {
        return this.rows;
    }

    public final void setRows(List<R> data) {
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        if (data.isEmpty()) {
            data.add(this.createNewRow());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Set " + data.size() + " row(s) in table model " + this));
        }
        this.rows = data;
        this.onRowsChanged(data);
        this.fireTableDataChanged();
    }

    public final void addNewRow() {
        R newValue = this.createNewRow();
        this.addNewRow(this.getRowCount(), newValue);
    }

    public final void addNewRow(int rowIndex, R newValue) {
        Preconditions.checkNotNull(newValue, (Object)"Row can not be null.");
        List<R> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        data.add(rowIndex, newValue);
        this.onRowAdded(rowIndex, newValue);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public final int updateRow(R row) {
        Preconditions.checkNotNull(row, (Object)"Row can not be null.");
        List<R> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        int rowIndex = data.indexOf(row);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        return rowIndex;
    }

    protected void onRowsChanged(List<R> data) {
    }

    protected void onRowAdded(int rowIndex, R newValue) {
    }

    public final ColumnIdentifier<R> getPropertyName(int columnIndex) {
        TableColumn column = this.getColumn(columnIndex);
        return (ColumnIdentifier)column.getIdentifier();
    }

    public final int getRowIndex(R row) {
        int result = this.rows == null ? -1 : this.rows.indexOf(row);
        return result;
    }

    public final R getEntry(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        List<R> data = this.getRows();
        Serializable result = data == null ? null : (Serializable)data.get(rowIndex);
        return (R)result;
    }

    public final void setNoneEditableCols(ColumnIdentifier<?> ... noneEditableCols) {
        this.noneEditableCols = Sets.newHashSet((Object[])noneEditableCols);
    }

    @Override
    public final int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    @Override
    public final int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        R entry = this.getEntry(rowIndex);
        ColumnIdentifier<R> propertyName = this.getPropertyName(columnIndex);
        Object result = this.getValueAt(rowIndex, columnIndex, propertyName, entry);
        return result;
    }

    @Override
    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        R entry = this.getEntry(rowIndex);
        ColumnIdentifier<R> propertyName = this.getPropertyName(columnIndex);
        this.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        ColumnIdentifier<R> identifier = this.getPropertyName(columnIndex);
        boolean result = this.isCellEditable(rowIndex, columnIndex, identifier);
        return result;
    }

    protected Object getValueAt(int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName, R entry) {
        Object result = propertyName.getValue(entry);
        return result;
    }

    protected void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName, R entry) {
        propertyName.setValue(entry, aValue);
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName) {
        boolean result = !this.noneEditableCols.contains(propertyName);
        return result;
    }

    protected final void fireTableCellUpdated(int rowIndex, ColumnIdentifier ... identifiers) {
        for (ColumnIdentifier identifier : identifiers) {
            int columnIndex = this.getColumnIndex(identifier);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    protected final TableColumn getColumn(int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        return this.columns[columnIndex];
    }

    protected final int getColumnIndex(ColumnIdentifier<?> property) {
        int result = this.columnIdentifiers.indexOf(property);
        return result;
    }
}

