/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FishingOperationsUIHandler
extends AbstractTuttiUIHandler<FishingOperationsUIModel> {
    private static final Log log = LogFactory.getLog(FishingOperationsUIHandler.class);
    private final FishingOperationsUI ui;
    private final PersistenceService persistenceService;

    public FishingOperationsUIHandler(TuttiUIContext context, FishingOperationsUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("for " + this.ui));
        }
        FishingOperationsUIModel model = new FishingOperationsUIModel();
        String cruiseId = this.context.getCruiseId();
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        model.setCruise(cruise);
        List fishingOperations = this.persistenceService.getAllFishingOperation(cruiseId);
        model.setFishingOperation(fishingOperations);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + fishingOperations.size() + " fishingOperation(s)."));
        }
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        FishingOperationsUIModel model = this.getModel();
        this.initUI(this.ui);
        List<FishingOperation> fishingOperations = model.getFishingOperation();
        this.initBeanComboBox(this.ui.getFishingOperationComboBox(), fishingOperations, model.getSelectedFishingOperation());
        model.addPropertyChangeListener("selectedFishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FishingOperationsUIHandler.this.selectFishingOperation((FishingOperation)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("fishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FishingOperationsUIHandler.this.ui.getFishingOperationComboBox().setData(null);
                FishingOperationsUIHandler.this.ui.getFishingOperationComboBox().setData((List)evt.getNewValue());
            }
        });
        if (!fishingOperations.isEmpty()) {
            model.setSelectedFishingOperation(fishingOperations.get(0));
        }
    }

    @Override
    public void onCloseUI() {
        this.ui.getTabPane().setSelectedIndex(0);
        this.ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
        this.selectFishingOperation(null);
    }

    @Override
    protected FishingOperationsUIModel getModel() {
        return this.ui.getModel();
    }

    public void createNewFishingOperation() {
        this.getModel().setSelectedFishingOperation(null);
        FishingOperation newFishingOperation = new FishingOperation();
        newFishingOperation.setCruise(this.getModel().getCruise());
        Date currentDate = new Date();
        currentDate = DateUtils.setHours((Date)currentDate, (int)0);
        currentDate = DateUtils.setMinutes((Date)currentDate, (int)0);
        newFishingOperation.setDate(currentDate);
        newFishingOperation.setGearShootingStartDate(currentDate);
        newFishingOperation.setGearShootingEndDate(currentDate);
        this.selectFishingOperation(newFishingOperation);
    }

    public void selectFishingOperation(FishingOperation fishingOperation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected fishingOperation: " + fishingOperation));
        }
        this.ui.getTabPane().setSelectedIndex(0);
        this.ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
        this.ui.getFishingOperationTabContent().selectFishingOperation(fishingOperation);
        this.ui.getSpeciesTabContent().selectFishingOperation(fishingOperation);
        this.ui.getBenthosTabContent().selectFishingOperation(fishingOperation);
        this.ui.getPlanktonTabContent().selectFishingOperation(fishingOperation);
        this.ui.getMacroDechetTabContent().selectFishingOperation(fishingOperation);
        this.ui.getAccidentelTabContent().selectFishingOperation(fishingOperation);
        this.ui.getTabPane().repaint();
    }

    public void saveFishingOperation(FishingOperation toSave) {
        boolean create = toSave.getId() == null;
        FishingOperation savedFishingOperation = create ? this.persistenceService.createFishingOperation(toSave) : this.persistenceService.saveFishingOperation(toSave);
        FishingOperationsUIModel model = this.getModel();
        List<FishingOperation> data = model.getFishingOperation();
        FishingOperation existingFishingOperation = (FishingOperation)TuttiEntities.findById(data, (String)savedFishingOperation.getId());
        if (existingFishingOperation != null) {
            data.remove(existingFishingOperation);
        }
        data.add(savedFishingOperation);
        model.setFishingOperation(data);
        model.setSelectedFishingOperation(savedFishingOperation);
    }
}

