/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectCruiseUIHandler
extends AbstractTuttiUIHandler<SelectCruiseUIModel> {
    private static final Log log = LogFactory.getLog(SelectCruiseUIHandler.class);
    protected final PersistenceService persistenceService;
    protected final SelectCruiseUI ui;

    public SelectCruiseUIHandler(TuttiUIContext context, SelectCruiseUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    protected SelectCruiseUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        SelectCruiseUIModel model = new SelectCruiseUIModel();
        List allPrograms = this.persistenceService.getAllProgram();
        model.setPrograms(allPrograms);
        if (allPrograms.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No program found.");
            }
        } else {
            String programId = this.context.getProgramId();
            Program selectedProgram = null;
            List allCruises = null;
            if (programId != null) {
                selectedProgram = (Program)TuttiEntities.findById((Iterable)allPrograms, (String)programId);
                allCruises = this.persistenceService.getAllCruise(programId);
            }
            model.setProgram(selectedProgram);
            model.setCruises(allCruises);
            if (!CollectionUtils.isEmpty(allCruises)) {
                String cruiseId = this.context.getCruiseId();
                Cruise selectedCampaign = null;
                if (cruiseId != null) {
                    selectedCampaign = (Cruise)TuttiEntities.findById((Iterable)allCruises, (String)cruiseId);
                }
                model.setCruise(selectedCampaign);
            }
        }
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        SelectCruiseUIModel model = this.ui.getModel();
        this.initBeanComboBox(this.ui.getProgramCombobox(), model.getPrograms(), model.getProgram());
        this.initBeanComboBox(this.ui.getCruiseCombobox(), model.getCruises(), model.getCruise());
        model.addPropertyChangeListener("program", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Program newValue = (Program)evt.getNewValue();
                boolean noProgram = newValue == null;
                SelectCruiseUIHandler.this.context.setProgramId(noProgram ? null : newValue.getId());
                List campaigns = noProgram ? Lists.newArrayList() : SelectCruiseUIHandler.this.persistenceService.getAllCruise(newValue.getId());
                SelectCruiseUIModel model = (SelectCruiseUIModel)((Object)evt.getSource());
                model.setCruises(campaigns);
                model.setCruise(null);
            }
        });
        model.addPropertyChangeListener("cruises", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanComboBox<Cruise> combobox = SelectCruiseUIHandler.this.ui.getCruiseCombobox();
                List campaigns = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("cruise", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cruise newValue = (Cruise)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setCruiseId(newValue == null ? null : newValue.getId());
            }
        });
    }

    @Override
    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = this.ui.getModel().getPropertyChangeListeners()) {
            this.getModel().removePropertyChangeListener(listener);
        }
    }

    public void showFishingOperations() {
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showSelectedProgram() {
        Program program = this.getModel().getProgram();
        this.context.setProgramId(program.getId());
        this.context.setScreen(TuttiScreen.EDIT_PROGRAM);
    }

    public void showNewProgram() {
        this.context.setProgramId(null);
        this.context.setCruiseId(null);
        this.context.setScreen(TuttiScreen.EDIT_PROGRAM);
    }

    public void showSelectedCruise() {
        Cruise cruise = this.getModel().getCruise();
        this.context.setCruiseId(cruise.getId());
        this.context.setScreen(TuttiScreen.EDIT_CRUISE);
    }

    public void showNewCruise() {
        this.context.setCruiseId(null);
        this.context.setScreen(TuttiScreen.EDIT_CRUISE);
    }
}

