/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.widget.SwingSession;

public class TuttiUIContext
extends AbstractBean
implements Closeable {
    private static final Log log = LogFactory.getLog(TuttiUIContext.class);
    public static final String PROPERTY_PROGRAM_ID = "programId";
    public static final String PROPERTY_CRUISE_ID = "cruiseId";
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_CRUISE_CONTEXT_FILLED = "cruiseContextFilled";
    private static TuttiUIContext applicationContext;
    protected final TuttiConfig config;
    protected final TuttiServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected String programId;
    protected String cruiseId;
    protected TuttiScreen screen;

    public static TuttiUIContext newContext(TuttiConfig config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new TuttiUIContext(config);
        return applicationContext;
    }

    protected TuttiUIContext(TuttiConfig config) {
        this.config = config;
        this.serviceContext = new TuttiServiceContext(config.getServiceConfig());
        this.swingSession = new SwingSession(this.getConfig().getUIConfigFile(), false);
    }

    public <S extends TuttiService> S getService(Class<S> serviceType) {
        return (S)this.serviceContext.getService(serviceType);
    }

    public TuttiConfig getConfig() {
        return this.config;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public String getProgramId() {
        return this.programId;
    }

    public String getCruiseId() {
        return this.cruiseId;
    }

    public boolean isCruiseContextFilled() {
        return StringUtils.isNotBlank((CharSequence)this.programId) && StringUtils.isNotBlank((CharSequence)this.cruiseId);
    }

    public TuttiScreen getScreen() {
        return this.screen;
    }

    public void setProgramId(String programId) {
        boolean oldValue = this.isCruiseContextFilled();
        this.programId = programId;
        this.firePropertyChange(PROPERTY_PROGRAM_ID, null, programId);
        this.firePropertyChange(PROPERTY_CRUISE_CONTEXT_FILLED, oldValue, this.isCruiseContextFilled());
    }

    public void setCruiseId(String cruiseId) {
        boolean oldValue = this.isCruiseContextFilled();
        this.cruiseId = cruiseId;
        this.firePropertyChange(PROPERTY_CRUISE_ID, null, cruiseId);
        this.firePropertyChange(PROPERTY_CRUISE_CONTEXT_FILLED, oldValue, this.isCruiseContextFilled());
    }

    public void setScreen(TuttiScreen screen) {
        TuttiScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public void open() {
        if (this.programId == null) {
            this.setProgramId(this.getConfig().getProgramId());
        }
        if (this.cruiseId == null) {
            this.setCruiseId(this.getConfig().getCruiseId());
        }
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        if (this.programId != null) {
            Program program = persistenceService.getProgram(this.programId);
            if (program == null) {
                this.setProgramId(null);
                this.setCruiseId(null);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Remove invalid programId: " + this.programId));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("ProgramId valid: " + this.programId));
                }
                this.setProgramId(this.programId);
                if (this.cruiseId != null) {
                    Cruise campaign = persistenceService.getCruise(this.cruiseId);
                    if (campaign != null && !campaign.getProgram().getId().equals(this.programId)) {
                        campaign = null;
                    }
                    if (campaign == null) {
                        this.setCruiseId(null);
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Remove invalid cruiseId: " + this.cruiseId));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("CruiseId valid: " + this.cruiseId));
                    }
                }
            }
        }
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){
            Set<String> acceptedProperties = Sets.newHashSet((Object[])new String[]{"programId", "cruiseId"});

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.acceptedProperties.contains(evt.getPropertyName())) {
                    TuttiUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.programId = null;
        this.cruiseId = null;
        IOUtils.closeQuietly((Closeable)this.serviceContext);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
    }

    protected void saveContextToConfig() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save config (programId: " + this.programId + ", cruiseId: " + this.cruiseId + ")"));
        }
        this.config.setProgramId(this.programId);
        this.config.setCruiseId(this.cruiseId);
        this.config.save();
    }
}

