package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProgramUIHandler.java 40 2012-12-11 14:19:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/program/EditProgramUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Handler of UI {@link EditProgramUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditProgramUIHandler extends AbstractTuttiUIHandler<EditProgramUIModel> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditProgramUIHandler.class);

    private final EditProgramUI ui;

    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUIContext context, EditProgramUI ui) {
        super(context);
        this.ui = ui;
        persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        EditProgramUIModel model = new EditProgramUIModel();

        String surveyId = context.getProgramId();
        if (surveyId == null) {

            if (log.isInfoEnabled()) {
                log.info("Edit new program");
            }
        } else {

            if (log.isInfoEnabled()) {
                log.info("Edit existing program " + surveyId);
            }
            // load existing program
            Program program = persistenceService.getProgram(surveyId);

            model.fromBean(program);
        }

        listModelIsModify(model);

        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        EditProgramUIModel model = ui.getModel();
        initBeanComboBox(ui.getZoneComboBox(),
                         persistenceService.getAllZone(),
                         model.getZone());

        SwingValidatorUtil.installUI(ui.getErrorTable(),
                                     new SwingValidatorMessageTableRenderer());

        listenValidatorValid(ui.getValidator(), model);

        // if new program can already cancel his creation
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        ui.getValidator().setBean(null);
    }

    @Override
    protected EditProgramUIModel getModel() {
        return ui.getModel();
    }

    public void cancel() {
        context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void save() {

        EditProgramUIModel model = ui.getModel();

        Program bean = model.toBean();

        Program saved;
        if (TuttiEntities.isNew(bean)) {

            saved = persistenceService.createProgram(bean);
        } else {
            saved = persistenceService.saveProgram(bean);
        }

        context.setProgramId(saved.getId());
        context.setScreen(TuttiScreen.SELECT_CRUISE);
    }
}
