package fr.ifremer.tutti.ui.swing.content.operation.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesFrequencyUIModel.java 46 2012-12-12 17:06:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/species/SpeciesFrequencyUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class SpeciesFrequencyUIModel extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, SpeciesFrequencyRowModel, SpeciesFrequencyUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";

    public static final String PROPERTY_STEP = "step";

    private static final String PROPERTY_MIN_STEP = "minStep";

    private static final String PROPERTY_MAX_STEP = "maxStep";

    public static final String PROPERTY_CAN_GENERATE = "canGenerate";

    public static final String PROPERTY_SIMPLE_MODE = "simpleMode";

    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";

    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";

    public static enum ConfigurationMode {
        SIMPLE,
        AUTO_GEN,
        RAFALE
    }

    /**
     * Fill mode.
     *
     * @since 0.2
     */
    protected ConfigurationMode configurationMode;

    /**
     * Batch that contains frequencies.
     *
     * @since 0.2
     */
    protected SpeciesBatchRowModel batch;

    /**
     * Default step to increment length step.
     *
     * @since 0.2
     */
    protected float step;

    /**
     * Min step to auto generate length steps.
     *
     * @since 0.2
     */
    protected Float minStep;

    /**
     * Max step to auto generate length steps.
     *
     * @since 0.2
     */
    protected Float maxStep;

    public SpeciesFrequencyUIModel() {
        super(SpeciesBatchRowModel.class, null, null);
    }

    public ConfigurationMode getConfigurationMode() {
        return configurationMode;
    }

    public void setConfigurationMode(ConfigurationMode configurationMode) {
        Object oldValue = getConfigurationMode();
        this.configurationMode = configurationMode;
        firePropertyChange(PROPERTY_CONFIGURATION_MODE, oldValue, configurationMode);
        firePropertyChange(PROPERTY_SIMPLE_MODE, null, isSimpleMode());
        firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, isAutoGenMode());
        firePropertyChange(PROPERTY_RAFALE_MODE, null, isRafaleMode());
    }

    public float getStep() {
        return step;
    }

    public void setStep(float step) {
        Object oldValue = getStep();
        this.step = step;
        firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public Float getMinStep() {
        return minStep;
    }

    public void setMinStep(Float minStep) {
        Object oldValue = getMinStep();
        this.minStep = minStep;
        firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        firePropertyChange(PROPERTY_CAN_GENERATE, null, isCanGenerate());
    }

    public Float getMaxStep() {
        return maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Object oldValue = getMaxStep();
        this.maxStep = maxStep;
        firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        firePropertyChange(PROPERTY_CAN_GENERATE, null, isCanGenerate());
    }

    public boolean isSimpleMode() {
        return ConfigurationMode.SIMPLE == configurationMode;
    }

    public boolean isAutoGenMode() {
        return ConfigurationMode.AUTO_GEN == configurationMode;
    }

    public boolean isRafaleMode() {
        return ConfigurationMode.RAFALE == configurationMode;
    }

    public boolean isCanGenerate() {
        return minStep != null && maxStep != null && maxStep > minStep;
    }

    public SpeciesBatchRowModel getBatch() {
        return batch;
    }

    public void setBatch(SpeciesBatchRowModel batch) {
        this.batch = batch;
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int) (lengthStep * 10);
        int intStep = (int) (step * 10);
        int correctIntStep = intValue - (intValue % intStep);
        float result = correctIntStep / 10f;
        return result;
    }
}