package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiBeanUIModel.java 30 2012-12-06 17:03:05Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/AbstractTuttiBeanUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.service.TuttiServiceTechnicalException;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.util.beans.Binder;

/**
 * Abstract UI model to edit a bean.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public abstract class AbstractTuttiBeanUIModel<E, B extends AbstractTuttiBeanUIModel<E, B>> extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_MODIFY = "modify";

    public static final String PROPERTY_VALID = "valid";

    protected String id;

    protected boolean modify;

    protected boolean valid;

    private final Class<E> entityType;

    private final Binder<E, B> fromBeanBinder;

    private final Binder<B, E> toBeanBinder;

    protected AbstractTuttiBeanUIModel(Class<E> entityType,
                                       Binder<E, B> fromBeanBinder,
                                       Binder<B, E> toBeanBinder) {
        this.entityType = entityType;
        this.fromBeanBinder = fromBeanBinder;
        this.toBeanBinder = toBeanBinder;
    }

    public final void fromBean(E bean) {
        fromBeanBinder.copy(bean, (B) this);
    }

    public final E toBean() {
        E result = newEntity();
        toBeanBinder.copy((B) this, result);
        return result;
    }

    protected E newEntity() {
        try {
            E result = entityType.newInstance();
            return result;
        } catch (Exception e) {
            throw new TuttiServiceTechnicalException(
                    "Could not instanciate entity of type " +
                    entityType.getName(), e);
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        Object oldValue = getId();
        this.id = id;
        firePropertyChange(PROPERTY_ID, oldValue, id);
    }

    public boolean isModify() {
        return modify;
    }

    public void setModify(boolean modify) {
        Object oldValue = isModify();
        this.modify = modify;
        firePropertyChange(PROPERTY_MODIFY, oldValue, modify);
    }

    public boolean isValid() {
        return valid;
    }

    public void setValid(boolean valid) {
        Object oldValue = isValid();
        this.valid = valid;
        firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }

    public boolean isCreate() {
        return id == null;
    }
}
