/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import java.util.List;
import javax.swing.JTable;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCruiseUIHandler
extends AbstractTuttiUIHandler<EditCruiseUIModel> {
    private static final Log log = LogFactory.getLog(EditCruiseUIHandler.class);
    private final EditCruiseUI ui;
    private final PersistenceService persistenceService;
    public static final String cruiseNameFormat = "%1$s_%2$s";

    public EditCruiseUIHandler(TuttiUIContext context, EditCruiseUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditCruiseUIModel model = new EditCruiseUIModel();
        String cruiseId = this.context.getCruiseId();
        if (cruiseId == null) {
            Program program = this.persistenceService.getProgram(this.context.getProgramId());
            model.setProgram(program);
            model.setPoche(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create a new cruise from program: " + program));
            }
        } else {
            Cruise cruise = this.persistenceService.getCruise(cruiseId);
            model.fromBean(cruise);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit cruise: " + cruiseId));
            }
        }
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        List users = this.persistenceService.getAllPerson();
        EditCruiseUIModel model = this.getModel();
        this.initBeanComboBox(this.ui.getSurveyComboBox(), this.persistenceService.getAllProgram(), model.getProgram());
        this.initBeanComboBox(this.ui.getCountryComboBox(), this.persistenceService.getAllCountry(), model.getCountry());
        this.initBeanList(this.ui.getVesselList(), this.persistenceService.getAllVessel(), model.getVessel());
        this.initBeanList(this.ui.getGearList(), this.persistenceService.getAllGear(), model.getGear());
        this.initBeanList(this.ui.getHeadOfMissionList(), users, model.getHeadOfMission());
        this.initBeanList(this.ui.getHeadOfSortRoomList(), users, model.getHeadOfSortRoom());
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    protected EditCruiseUIModel getModel() {
        return this.ui.getModel();
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void save() {
        EditCruiseUIModel model = this.getModel();
        Cruise bean = (Cruise)model.toBean();
        Cruise saved = TuttiEntities.isNew((IdAware)bean) ? this.persistenceService.createCruise(bean) : this.persistenceService.saveCruise(bean);
        this.context.setProgramId(saved.getProgram().getId());
        this.context.setCruiseId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void generateCampaignName() {
        EditCruiseUIModel model = this.getModel();
        Program program = model.getProgram();
        Integer year = model.getYear();
        String name = String.format(cruiseNameFormat, program.getName(), year);
        String surveyPart = model.getSurveyPart();
        if (StringUtils.isNotEmpty((CharSequence)surveyPart)) {
            name = name + "_" + surveyPart;
        }
        model.setName(name);
    }
}

