package fr.ifremer.tutti.ui.swing.content.operation.fishing.environment;

/*
 * #%L
 * Tutti :: UI
 * $Id: EnvironmentTabUIModel.java 146 2013-01-02 18:51:13Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/environment/EnvironmentTabUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @author kmorin
 * @since 0.3
 */
public class EnvironmentTabUIModel extends AbstractTuttiTableUIModel<FishingOperation, EnvironmentRowModel, EnvironmentTabUIModel> {

    private static final long serialVersionUID = 1L;
    
    public static final String PROPERTY_REMOVE_CARACTERISTIC_ENABLED = "removeCaracteristicEnabled";

    protected List<Caracteristic> availableCaracteristics;
    
    /**
     * Fishing operation associated with the caracteristics
     * 
     * @since 0.3
     */
    protected FishingOperation fishingOperation;
    
    /**
     * Can user remove a selected caracteristic?
     *
     * @since 0.3
     */
    protected boolean removeCaracteristicEnabled;

    protected static final Binder<FishingOperation, EnvironmentTabUIModel> fromBeanBinder = BinderModelBuilder.newEmptyBuilder(FishingOperation.class, EnvironmentTabUIModel.class)
            .toBinder();

    protected static final Binder<EnvironmentTabUIModel, FishingOperation> toBeanBinder = BinderModelBuilder.newEmptyBuilder(EnvironmentTabUIModel.class, FishingOperation.class)
            .toBinder();

    public EnvironmentTabUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
    }

    public List<Caracteristic> getAvailableCaracteristics() {
        return availableCaracteristics;
    }

    public void setAvailableCaracteristics(List<Caracteristic> caracteristics) {
        availableCaracteristics = caracteristics;
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }
    
    public boolean isRemoveCaracteristicEnabled() {
        return removeCaracteristicEnabled;
    }

    public void setRemoveCaracteristicEnabled(boolean removeCaracteristicEnabled) {
        Object oldValue = isRemoveCaracteristicEnabled();
        this.removeCaracteristicEnabled = removeCaracteristicEnabled;
        firePropertyChange(PROPERTY_REMOVE_CARACTERISTIC_ENABLED, oldValue, removeCaracteristicEnabled);
    }
}
