package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCruiseUI extends JPanel implements TuttiUI<EditCruiseUIModel, EditCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BEGIN_DATE_FIELD_DATE = "beginDateField.date";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM = "countryComboBox.selectedItem";
    public static final String BINDING_END_DATE_FIELD_DATE = "endDateField.date";
    public static final String BINDING_GENERATE_NAME_BUTTON_ENABLED = "generateNameButton.enabled";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_POCHE_FIELD_MODEL = "pocheField.model";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_COMBO_BOX_SELECTED_ITEM = "surveyComboBox.selectedItem";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";
    public static final String BINDING_YEAR_FIELD_MODEL = "yearField.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "beginDate",  editorName = "beginDateField")
    protected JXDatePicker beginDateField;
    protected JLabel beginDateLabel;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "country",  editorName = "countryComboBox")
    protected BeanComboBox<Country> countryComboBox;
    protected JLabel countryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "endDate",  editorName = "endDateField")
    protected JXDatePicker endDateField;
    protected JLabel endDateLabel;
    protected JTable errorTable;
    protected SwingValidatorMessageTableModel errorTableModel;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearList")
    protected BeanDoubleList<Gear> gearList;
    protected JButton generateNameButton;
    protected EditCruiseUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionList")
    protected BeanDoubleList<Person> headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomList")
    protected BeanDoubleList<Person> headOfSortRoomList;
    protected EditCruiseUI homePanel = this;
    protected JPanel messagePanel;
    protected EditCruiseUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "poche",  editorName = "pocheField")
    protected NumberEditor pocheField;
    protected JLabel pocheLabel;
    protected JLabel programLabel;
    protected JButton saveButton;
    protected JSplitPane splitPane;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "surveyComboBox")
    protected BeanComboBox<Program> surveyComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselList")
    protected BeanDoubleList<Vessel> vesselList;
    @ValidatorField( validatorId = "validator",  propertyName = "year",  editorName = "yearField")
    protected NumberEditor yearField;
    protected JLabel yearLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCruiseUI(TuttiUIContext context) {
        EditCruiseUIHandler handler = new EditCruiseUIHandler(context, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI() {
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "beginDate");
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__endDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "endDate");
    }

    public void doActionPerformed__on__generateNameButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateCampaignName();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getBeginDateField() {
        return beginDateField;
    }

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public BeanComboBox<Country> getCountryComboBox() {
        return countryComboBox;
    }

    public JLabel getCountryLabel() {
        return countryLabel;
    }

    public JXDatePicker getEndDateField() {
        return endDateField;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public BeanDoubleList<Gear> getGearList() {
        return gearList;
    }

    public JButton getGenerateNameButton() {
        return generateNameButton;
    }

    public EditCruiseUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Person> getHeadOfMissionList() {
        return headOfMissionList;
    }

    public BeanDoubleList<Person> getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public JPanel getMessagePanel() {
        return messagePanel;
    }

    public EditCruiseUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public NumberEditor getPocheField() {
        return pocheField;
    }

    public JLabel getPocheLabel() {
        return pocheLabel;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public BeanComboBox<Program> getSurveyComboBox() {
        return surveyComboBox;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public SwingValidator<EditCruiseUIModel> getValidator() {
        return validator;
    }

    public BeanDoubleList<Vessel> getVesselList() {
        return vesselList;
    }

    public NumberEditor getYearField() {
        return yearField;
    }

    public JLabel getYearLabel() {
        return yearLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(splitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMessagePanel() {
        if (!allComponentsCreated) {
            return;
        }
        messagePanel.add($JScrollPane0);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($Table0, JSplitPane.LEFT);
        splitPane.add(messagePanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBeginDateField() {
        $objectMap.put("beginDateField", beginDateField = new JXDatePicker());
        
        beginDateField.setName("beginDateField");
        beginDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDateField"));
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(_("tutti.label.cruise.beginDate"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createCountryComboBox() {
        $objectMap.put("countryComboBox", countryComboBox = new BeanComboBox<Country>(this));
        
        countryComboBox.setName("countryComboBox");
        countryComboBox.setI18nPrefix("tutti.property.");
        countryComboBox.setProperty("country");
        countryComboBox.setShowReset(true);
    }

    protected void createCountryLabel() {
        $objectMap.put("countryLabel", countryLabel = new JLabel());
        
        countryLabel.setName("countryLabel");
        countryLabel.setText(_("tutti.label.cruise.country"));
    }

    protected void createEndDateField() {
        $objectMap.put("endDateField", endDateField = new JXDatePicker());
        
        endDateField.setName("endDateField");
        endDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDateField"));
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(_("tutti.label.cruise.endDate"));
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setAutoCreateRowSorter(true);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Gear>());
        
        gearList.setName("gearList");
        gearList.setProperty("gear");
    }

    protected void createGenerateNameButton() {
        $objectMap.put("generateNameButton", generateNameButton = new JButton());
        
        generateNameButton.setName("generateNameButton");
        generateNameButton.setText(_("tutti.action.generateCampaignName"));
        generateNameButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateNameButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCruiseUIHandler.class));
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new BeanDoubleList<Person>());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.setProperty("headOfMission");
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new BeanDoubleList<Person>());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.setProperty("headOfSortRoom");
    }

    protected void createMessagePanel() {
        $objectMap.put("messagePanel", messagePanel = new JPanel());
        
        messagePanel.setName("messagePanel");
        messagePanel.setLayout(new GridLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCruiseUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.label.cruise.name"));
    }

    protected void createPocheField() {
        $objectMap.put("pocheField", pocheField = new NumberEditor(this));
        
        pocheField.setName("pocheField");
        pocheField.setProperty("poche");
        pocheField.setUseFloat(false);
        pocheField.setShowReset(true);
    }

    protected void createPocheLabel() {
        $objectMap.put("pocheLabel", pocheLabel = new JLabel());
        
        pocheLabel.setName("pocheLabel");
        pocheLabel.setText(_("tutti.label.cruise.poche"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.label.cruise.program"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.3);
        splitPane.setOneTouchExpandable(true);
    }

    protected void createSurveyComboBox() {
        $objectMap.put("surveyComboBox", surveyComboBox = new BeanComboBox<Program>(this));
        
        surveyComboBox.setName("surveyComboBox");
        surveyComboBox.setI18nPrefix("tutti.property.");
        surveyComboBox.setProperty("program");
        surveyComboBox.setShowReset(true);
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(_("tutti.label.cruise.surveyPart"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCruiseUIModel.class, null));
    }

    protected void createVesselList() {
        $objectMap.put("vesselList", vesselList = new BeanDoubleList<Vessel>());
        
        vesselList.setName("vesselList");
        vesselList.setProperty("vessel");
    }

    protected void createYearField() {
        $objectMap.put("yearField", yearField = new NumberEditor(this));
        
        yearField.setName("yearField");
        yearField.setProperty("year");
        yearField.setUseFloat(false);
        yearField.setShowReset(true);
    }

    protected void createYearLabel() {
        $objectMap.put("yearLabel", yearLabel = new JLabel());
        
        yearLabel.setName("yearLabel");
        yearLabel.setText(_("tutti.label.cruise.year"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToSplitPane();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyComboBox), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(yearLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(yearField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(generateNameButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(pocheLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(pocheField), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(countryComboBox), new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(beginDateField), new GridBagConstraints(3, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(endDateField), new GridBagConstraints(5, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 4, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(commentPane, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(vesselList));
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(gearList));
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfMissionList));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomList));
        addChildrenToCommentPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(cancelButton);
        $JPanel2.add(saveButton);
        addChildrenToMessagePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 49 property setters
        surveyComboBox.setBeanType(Program.class);
        countryComboBox.setBeanType(Country.class);
        vesselList.setBeanType(Vessel.class);
        gearList.setBeanType(Gear.class);
        headOfMissionList.setBeanType(Person.class);
        headOfSortRoomList.setBeanType(Person.class);
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        programLabel.setLabelFor(surveyComboBox);
        surveyComboBox.setBean(model);
        yearLabel.setLabelFor(yearField);
        yearField.setBean(model);
        yearField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        yearField.setNumberPattern(INT_4_DIGITS_PATTERN);
        yearField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        surveyPartLabel.setLabelFor(surveyPartField);
        nameLabel.setLabelFor(nameField);
        generateNameButton.setIcon(SwingUtil.createActionIcon("generate"));
        pocheLabel.setLabelFor(pocheField);
        pocheField.setBean(model);
        pocheField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        pocheField.setNumberPattern(INT_1_DIGITS_PATTERN);
        pocheField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        countryLabel.setLabelFor(countryComboBox);
        countryComboBox.setBean(model);
        beginDateLabel.setLabelFor(beginDateField);
        beginDateField.setFormats("dd/MM/yyyy");
        endDateLabel.setLabelFor(endDateField);
        endDateField.setFormats("dd/MM/yyyy");
        vesselList.setBean(model);
        vesselList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.vessel")));
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.gear")));
        headOfMissionList.setBean(model);
        headOfMissionList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.headOfMission")));
        headOfSortRoomList.setBean(model);
        headOfSortRoomList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.headOfSortRoom")));
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        messagePanel.setBorder(BorderFactory.createTitledBorder(_("tutti.title.messages")));
        errorTable.setModel(errorTableModel);
        errorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        errorTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createSplitPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createSurveyComboBox();
        createYearLabel();
        createYearField();
        createSurveyPartLabel();
        createSurveyPartField();
        createNameLabel();
        createNameField();
        createGenerateNameButton();
        createPocheLabel();
        createPocheField();
        createCountryLabel();
        createCountryComboBox();
        createBeginDateLabel();
        createBeginDateField();
        createEndDateLabel();
        createEndDateField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createVesselList();
        createGearList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createHeadOfMissionList();
        createHeadOfSortRoomList();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        createMessagePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    surveyComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEAR_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("year", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    yearField.setModel(model.getYear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("year", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_NAME_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerateName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateNameButton.setEnabled(model.isCanGenerateName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerateName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_POCHE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("poche", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pocheField.setModel(model.getPoche());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("poche", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    countryComboBox.setSelectedItem(model.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEGIN_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beginDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beginDateField.setDate(model.getBeginDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beginDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("endDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    endDateField.setDate(model.getEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("endDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}