/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.catches;

import fr.ifremer.tutti.persistence.entities.SpeciesBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.catches.CatchesUI;
import fr.ifremer.tutti.ui.swing.content.catches.FishesTabUI;
import fr.ifremer.tutti.ui.swing.content.catches.FishesTabUIModel;
import fr.ifremer.tutti.ui.swing.content.catches.FishesTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FishesTabUIHandler
extends AbstractTuttiUIHandler<FishesTabUIModel> {
    private static final Log log = LogFactory.getLog(FishesTabUIHandler.class);
    private final FishesTabUI ui;
    private final CatchesUI parentUi;
    private final PersistenceService persistenceService;

    public FishesTabUIHandler(CatchesUI parentUi, FishesTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        FishesTabUIModel model = new FishesTabUIModel();
        this.ui.setContextValue(model);
        JTable tb = new JTable();
        TableCellEditor defaultEditor = tb.getDefaultEditor(String.class);
        TableCellRenderer defaultRenderer = tb.getDefaultRenderer(Object.class);
        DefaultTableCellRenderer dRender = new DefaultTableCellRenderer();
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn col = new TableColumn(0);
        JComboBox speciesEditor = new JComboBox();
        List allSpecies = this.persistenceService.getAllSpecies();
        SwingUtil.fillComboBox(speciesEditor, (Collection)allSpecies, null);
        col.setCellRenderer(this.newTableCellRender(SpeciesBean.class));
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.speciesByCode", (Object[])new Object[0]));
        col.setIdentifier("speciesByCode");
        columnModel.addColumn(col);
        col = new TableColumn(1);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.vracHorsVrac", (Object[])new Object[0]));
        col.setIdentifier("vracHorsVrac");
        columnModel.addColumn(col);
        col = new TableColumn(2);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.weightCategory", (Object[])new Object[0]));
        col.setIdentifier("weightCategory");
        columnModel.addColumn(col);
        col = new TableColumn(3);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.sex", (Object[])new Object[0]));
        col.setIdentifier("sex");
        columnModel.addColumn(col);
        col = new TableColumn(4);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.maturity", (Object[])new Object[0]));
        col.setIdentifier("maturity");
        columnModel.addColumn(col);
        col = new TableColumn(5);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.age", (Object[])new Object[0]));
        col.setIdentifier("age");
        columnModel.addColumn(col);
        col = new TableColumn(6);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.mensurationType", (Object[])new Object[0]));
        col.setIdentifier("mensurationType");
        columnModel.addColumn(col);
        col = new TableColumn(7);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.weight", (Object[])new Object[0]));
        col.setIdentifier("weight");
        columnModel.addColumn(col);
        col = new TableColumn(8);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.computedWeight", (Object[])new Object[0]));
        col.setIdentifier("computedWeight");
        columnModel.addColumn(col);
        col = new TableColumn(9);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.computedNumber", (Object[])new Object[0]));
        col.setIdentifier("computedNumber");
        columnModel.addColumn(col);
        col = new TableColumn(10);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.sampleWeight", (Object[])new Object[0]));
        col.setIdentifier("sampleWeight");
        columnModel.addColumn(col);
        col = new TableColumn(11);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.fishes.header.elevationRate", (Object[])new Object[0]));
        col.setIdentifier("elevationRate");
        columnModel.addColumn(col);
        this.ui.setContextValue(columnModel);
        final FishesTableModel tableModel = new FishesTableModel(columnModel);
        this.ui.setContextValue(tableModel);
        model.addPropertyChangeListener("catches", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                tableModel.setData((List)evt.getNewValue());
            }
        });
    }

    @Override
    public void afterInitUI() {
        FishesTabUIModel model = this.ui.getModel();
        this.initUI(this.ui);
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected FishesTabUIModel getModel() {
        return this.ui.getModel();
    }

    public void selectTrait(TraitBean bean) {
        List catches;
        boolean empty = bean == null;
        FishesTabUIModel model = this.ui.getModel();
        if (empty) {
            catches = null;
            bean = new TraitBean();
        } else {
            catches = this.persistenceService.getAllCatches(bean.getId());
        }
        model.fromBean(bean);
        model.setCatches(catches);
    }

    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Cancel edition");
        }
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will save");
        }
    }
}

