package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CatchesUI extends JPanel implements TuttiUI<CatchesUIModel, CatchesUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BENTHOS_TAB_ENABLED = "benthosTab.enabled";
    public static final String BINDING_CAPTURE_ACCIDENTELLES_TAB_ENABLED = "captureAccidentellesTab.enabled";
    public static final String BINDING_FISHES_TAB_ENABLED = "fishesTab.enabled";
    public static final String BINDING_MACRO_DECHETS_TAB_ENABLED = "macroDechetsTab.enabled";
    public static final String BINDING_OBSERVATION_INDIVIDUELLES_TAB_ENABLED = "observationIndividuellesTab.enabled";
    public static final String BINDING_PLANCTON_TAB_ENABLED = "planctonTab.enabled";
    public static final String BINDING_TRAIT_COMBO_BOX_SELECTED_ITEM = "traitComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1WzW8bRRQfO3ESJ2mTJuoHpEhu6aFVxZq2gCpSoPlQFEcuREkqVfWF2d2xPdV4Zpl9m2xARfwJHLhw4ePOBYkbJ8SBMwcuiH8BIQ5cK97srr3+2DhWIzlSxvG8937vN2/e/F5++JsUfE2uPaNhaOlAAm8xa2ftyZOP7GfMgU3mO5p7oDSJf3J5kq+RObez7wN5vVY14eUkvLyhWp6STHZFr1bJrA/HgvlNxgDIa70Rju+X9zvm1dALdBu1QyoL9bt//8l/6X7xfZ6Q0EN2F/EopdOi0pNMVkmeu0CWMNMhLQsqG0hDc9lAvufM3oagvv8hbbFPyOdkukqmPKoRDMj10Y8cYUTxoQek2FQttkslE0Du1bXF65q1mLYgAOBWwC3/CPNbjpKAcJZDwWky39qIPx9XPC/CmgIy3aTSFUwDefclcLbj4BSu0FKuIXX/JcAemdAUagaUlxzxSs9txDAH1BZRQYudiHOgKQesoq3WVQjkdkYYczmW1bIZldY6Lm1vA7HUQTov2dGBAVtH7siXLJt7DBOMnXi3N2QaqG3oArnc44s8beYaSy/ZhYgsWjfiegB5a/SaHSSxjysGbaUDuljn2Px+N+rbo6NutYP7YS/Y6NZUPbjvjI673onuB565sVOlNhNv4vPpqVq0m+17x3y/lW27O8R2L8vWvgQgr2b3WEXWVdqTxU59zcbd1DCbVqjPMuehIjjYLoOmhRZ1tNpkWCTIiLzsUA8CzdYch7sIz4TISr2ibJ/pQwpcyYp0+SF3g35XTVZ6jodSaaVSmWpZrkYKOsBtfHO1QXXdQ1Osq1f6dNUARtYXl5b/+Pmvn7baYrqEuS9munbNAhQ5TysPVYib1AuxkgbARfkR9VZrpOgzgYMkGhRXM4jtJ2Ykh/kumHDLhFvb1G8iRGH6z19+vfTx7xMkv0VmhaLuFjX+FVKEpsYqKOGG3gcPI0bzRzO4LuLvBJBJoxT4uj+LhO053jS/c1/ualbnoXnEUecn5I8t7BDEOtpjvplPk6ADFmK1rmZUq0PZLv723/L+jw/bFcvhCV450T2tWuEpmeJScMmiAZTMlsyBM+f5LHBVOkOypgrBuTLfLYlJi21G6/ZAcfLmgCzEcy7GVcCKYgtaKJ1YpfhLxUgBmaCuGwYGZTc6n/lrjwyorHd6wvm4D5hbAdbCNxvfitVgsJ8YIrybt/CiZtq3goPB77ZmUekdHacxyWFDMGkGEM796yeSKF17ryQDIZ5nZUylZBzZuvRpHOm6RW8c+fqVdBw5T5LnceQepvkj5J8S9FjhmyPnH7gUaMnmiCEb7w+kypl1dgTE5abS/FN87FSsCd6QLSyIcf4qG/LmCJCJuCw9iEWuRAH/qbYDYCfQPB3TbH89hNXtkRC+Mcu3Z0EYxuGNM3MYDWEYh/KZORiE/wEF7p/+FQ4AAA==";
    private static final Log log = LogFactory.getLog(CatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo benthosTab;
    protected BenthosTabUI benthosTabContent;
    protected TabInfo captureAccidentellesTab;
    protected TabInfo fishesTab;
    protected FishesTabUI fishesTabContent;
    protected CatchesUIHandler handler;
    protected CatchesUI homePanel = this;
    protected TabInfo macroDechetsTab;
    protected CatchesUIModel model;
    protected JButton newTraitButton;
    protected TabInfo observationIndividuellesTab;
    protected TabInfo planctonTab;
    protected JTabbedPane tabPane;
    protected Table topPanel;
    protected BeanComboBox<TraitBean> traitComboBox;
    protected TabInfo traitTab;
    protected TraitTabUI traitTabContent;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CatchesUI(TuttiUIContext context) {
        CatchesUIHandler handler = new CatchesUIHandler(context, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CatchesUI() {
        $initialize();
    }

    public CatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__newTraitButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createNewTrait();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public BenthosTabUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public TabInfo getCaptureAccidentellesTab() {
        return captureAccidentellesTab;
    }

    public TabInfo getFishesTab() {
        return fishesTab;
    }

    public FishesTabUI getFishesTabContent() {
        return fishesTabContent;
    }

    public CatchesUIHandler getHandler() {
        return handler;
    }

    public TabInfo getMacroDechetsTab() {
        return macroDechetsTab;
    }

    public CatchesUIModel getModel() {
        return model;
    }

    public JButton getNewTraitButton() {
        return newTraitButton;
    }

    public TabInfo getObservationIndividuellesTab() {
        return observationIndividuellesTab;
    }

    public TabInfo getPlanctonTab() {
        return planctonTab;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    public BeanComboBox<TraitBean> getTraitComboBox() {
        return traitComboBox;
    }

    public TabInfo getTraitTab() {
        return traitTab;
    }

    public TraitTabUI getTraitTabContent() {
        return traitTabContent;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(traitTabContent);
        tabPane.add(fishesTabContent);
        tabPane.add(benthosTabContent);
        tabPane.add($JLabel0);
        tabPane.add($JLabel1);
        tabPane.add($JLabel2);
        tabPane.add($JLabel3);
        traitTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.trait"));
        fishesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.fishes"));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        tabPane.setTitleAt(2, _("tutti.label.tab.benthos"));
        planctonTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, _("tutti.label.tab.plancton"));
        macroDechetsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        tabPane.setTitleAt(4, _("tutti.label.tab.macroDechets"));
        captureAccidentellesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
        tabPane.setTitleAt(5, _("tutti.label.tab.captureAccidentelles"));
        observationIndividuellesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 6));
        tabPane.setTitleAt(6, _("tutti.label.tab.observationIndividuelles"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(traitComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(newTraitButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
        
        benthosTab.setTitle(_("tutti.label.tab.benthos"));
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosTabUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createCaptureAccidentellesTab() {
        $objectMap.put("captureAccidentellesTab", captureAccidentellesTab = new TabInfo());
        
        captureAccidentellesTab.setTitle(_("tutti.label.tab.captureAccidentelles"));
    }

    protected void createFishesTab() {
        $objectMap.put("fishesTab", fishesTab = new TabInfo());
        
        fishesTab.setTitle(_("tutti.label.tab.fishes"));
    }

    protected void createFishesTabContent() {
        $objectMap.put("fishesTabContent", fishesTabContent = new FishesTabUI(this));
        
        fishesTabContent.setName("fishesTabContent");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CatchesUIHandler.class));
    }

    protected void createMacroDechetsTab() {
        $objectMap.put("macroDechetsTab", macroDechetsTab = new TabInfo());
        
        macroDechetsTab.setTitle(_("tutti.label.tab.macroDechets"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CatchesUIModel.class));
    }

    protected void createNewTraitButton() {
        $objectMap.put("newTraitButton", newTraitButton = new JButton());
        
        newTraitButton.setName("newTraitButton");
        newTraitButton.setText(_("tutti.action.new"));
        newTraitButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTraitButton"));
    }

    protected void createObservationIndividuellesTab() {
        $objectMap.put("observationIndividuellesTab", observationIndividuellesTab = new TabInfo());
        
        observationIndividuellesTab.setTitle(_("tutti.label.tab.observationIndividuelles"));
    }

    protected void createPlanctonTab() {
        $objectMap.put("planctonTab", planctonTab = new TabInfo());
        
        planctonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    protected void createTraitComboBox() {
        $objectMap.put("traitComboBox", traitComboBox = new BeanComboBox<TraitBean>(this));
        
        traitComboBox.setName("traitComboBox");
        traitComboBox.setI18nPrefix("tutti.property.");
        traitComboBox.setProperty("selectedTrait");
        traitComboBox.setShowReset(true);
    }

    protected void createTraitTab() {
        $objectMap.put("traitTab", traitTab = new TabInfo());
        
        traitTab.setTitle(_("tutti.label.tab.trait"));
    }

    protected void createTraitTabContent() {
        $objectMap.put("traitTabContent", traitTabContent = new TraitTabUI(this));
        
        traitTabContent.setName("traitTabContent");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToTopPanel();
        addChildrenToTabPane();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        $JLabel1.setHorizontalAlignment(JLabel.CENTER);
        $JLabel2.setHorizontalAlignment(JLabel.CENTER);
        $JLabel3.setHorizontalAlignment(JLabel.CENTER);
        traitComboBox.setBean(model);
        newTraitButton.setIcon(SwingUtil.createActionIcon("add"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createTopPanel();
        createTraitComboBox();
        createNewTraitButton();
        createTabPane();
        createTraitTabContent();
        createFishesTabContent();
        createBenthosTabContent();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("tutti.to.be.done"));
        createTraitTab();
        createFishesTab();
        createBenthosTab();
        createPlanctonTab();
        createMacroDechetsTab();
        createCaptureAccidentellesTab();
        createObservationIndividuellesTab();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAIT_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    traitComboBox.setSelectedItem(model.getSelectedTrait());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHES_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishesTab.setEnabled(model.getSelectedTrait() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTab.setEnabled(model.getSelectedTrait() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PLANCTON_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    planctonTab.setEnabled(model.getSelectedTrait() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MACRO_DECHETS_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    macroDechetsTab.setEnabled(model.getSelectedTrait() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CAPTURE_ACCIDENTELLES_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    captureAccidentellesTab.setEnabled(model.getSelectedTrait() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBSERVATION_INDIVIDUELLES_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTrait", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    observationIndividuellesTab.setEnabled(model.getSelectedTrait() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTrait", this);
                }
            }
        });
    }

}