package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditSurveyUIModel.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/campaign/EditSurveyUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.persistence.entities.ZoneBean;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.BinderFactory;

/**
 * Bean to edit a survey.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditSurveyUIModel extends AbstractTuttiBeanUIModel {

    private static final long serialVersionUID = 1L;

    protected String name;

    protected String comment;

    protected ZoneBean zone;

//    protected boolean create;
//
//    public boolean isCreate() {
//        return create;
//    }
//
//    public void setCreate(boolean create) {
//        Object oldValue = isCreate();
//        this.create = create;
//        firePropertyChange("create", oldValue, create);
//    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        Object oldValue = getName();
        this.name = name;
        firePropertyChange("name", oldValue, name);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange("comment", oldValue, comment);
    }

    public ZoneBean getZone() {
        return zone;
    }

    public void setZone(ZoneBean zone) {
        Object oldValue = getZone();
        this.zone = zone;
        firePropertyChange("zone", oldValue, zone);
    }

    public void fromBean(SurveyBean bean) {
        BinderFactory.newBinder(SurveyBean.class,
                                EditSurveyUIModel.class).copy(bean, this);
    }

    public SurveyBean toBean() {
        SurveyBean result = new SurveyBean();
        BinderFactory.newBinder(EditSurveyUIModel.class,
                                SurveyBean.class).copy(this, result);
        return result;
    }
}
