package fr.ifremer.tutti.ui.swing.config;

/*
 * #%L
 * Tutti :: Application
 * $Id: TuttiConfigOption.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/config/TuttiConfigOption.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.util.ApplicationConfig;

import java.io.File;

import static org.nuiton.i18n.I18n.n_;

/**
 * All Tutti configuration options.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public enum TuttiConfigOption implements ApplicationConfig.OptionDef {

    UI_CONFIG_FILE("tutti.ui.config",
                   n_("tutti.config.ui.config"),
                   "${tutti.data.directory}/tuttiUI.xml",
                   File.class
    ),
    SURVEY_ID("tutti.surveyId",
              n_("tutti.config.surveyId"),
              null,
              String.class
    ),
    CAMPAIGN_ID("tutti.campaignId",
                n_("tutti.config.campaignId"),
                null,
                String.class
    ),

    // UI CONFIG (should be moved to ui module)
    AUTO_POPUP_NUMBER_EDITOR("tutti.ui.autoPopupNumberEditor",
                             n_("tutti.config.ui.autoPopupNumberEditor"),
                             String.valueOf(false),
                             Boolean.class
    ),

    SHOW_NUMBER_EDITOR_BUTTON("tutti.ui.showNumberEditorButton",
                              n_("tutti.config.ui.showNumberEditorButton"),
                              String.valueOf(true),
                              Boolean.class
    );

    /** Configuration key. */
    private final String key;

    /** I18n key of option description */
    private final String description;

    /** Type of option */
    private final Class<?> type;

    /** Default value of option. */
    private String defaultValue;

    /** Flag to not keep option value on disk */
    private boolean isTransient;

    /** Flag to not allow option value modification */
    private boolean isFinal;

    TuttiConfigOption(String key,
                      String description,
                      String defaultValue,
                      Class<?> type,
                      boolean isTransient,
                      boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isTransient = isTransient;
        this.isFinal = isFinal;
    }

    TuttiConfigOption(String key,
                      String description,
                      String defaultValue,
                      Class<?> type) {
        this(key, description, defaultValue, type, false, false);
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean newValue) {
        // not used
    }

    @Override
    public void setFinal(boolean newValue) {
        // not used
    }
}
