/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;

public class XSLFGraphicFrame
extends XSLFShape {
    private final CTGraphicalObjectFrame _shape;
    private final XSLFSheet _sheet;

    XSLFGraphicFrame(CTGraphicalObjectFrame shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
    }

    public CTGraphicalObjectFrame getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public int getShapeType() {
        throw new RuntimeException("NotImplemented");
    }

    public int getShapeId() {
        return (int)this._shape.getNvGraphicFramePr().getCNvPr().getId();
    }

    public String getShapeName() {
        return this._shape.getNvGraphicFramePr().getCNvPr().getName();
    }

    public Rectangle2D getAnchor() {
        CTTransform2D xfrm = this._shape.getXfrm();
        CTPoint2D off = xfrm.getOff();
        long x = off.getX();
        long y = off.getY();
        CTPositiveSize2D ext = xfrm.getExt();
        long cx = ext.getCx();
        long cy = ext.getCy();
        return new Rectangle2D.Double(Units.toPoints(x), Units.toPoints(y), Units.toPoints(cx), Units.toPoints(cy));
    }

    public void setAnchor(Rectangle2D anchor) {
        CTTransform2D xfrm = this._shape.getXfrm();
        CTPoint2D off = xfrm.isSetOff() ? xfrm.getOff() : xfrm.addNewOff();
        long x = Units.toEMU(anchor.getX());
        long y = Units.toEMU(anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetExt() ? xfrm.getExt() : xfrm.addNewExt();
        long cx = Units.toEMU(anchor.getWidth());
        long cy = Units.toEMU(anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    static XSLFGraphicFrame create(CTGraphicalObjectFrame shape, XSLFSheet sheet) {
        String uri = shape.getGraphic().getGraphicData().getUri();
        if (XSLFTable.TABLE_URI.equals(uri)) {
            return new XSLFTable(shape, sheet);
        }
        return new XSLFGraphicFrame(shape, sheet);
    }

    public void setRotation(double theta) {
        throw new IllegalArgumentException("Operation not supported");
    }

    public double getRotation() {
        return 0.0;
    }

    public void setFlipHorizontal(boolean flip) {
        throw new IllegalArgumentException("Operation not supported");
    }

    public void setFlipVertical(boolean flip) {
        throw new IllegalArgumentException("Operation not supported");
    }

    public boolean getFlipHorizontal() {
        return false;
    }

    public boolean getFlipVertical() {
        return false;
    }

    public void draw(Graphics2D graphics) {
    }
}

