/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class Style
extends StyleElement
implements IStyleModel {
    public Style() {
    }

    public Style(String theName) {
        super(theName);
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitStyle(this);
    }

    @Override
    public String getElementName() {
        return "Style";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public SharedStyleHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new SharedStyleHandle(module, this);
        }
        return (SharedStyleHandle)this.handle;
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(Style.validateStyleProperties(module, this));
        return list;
    }

    public static List<SemanticException> validateStyleProperties(Module module, DesignElement element) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        List<Object> rules = element.getListProperty(module, "highlightRules");
        if (rules != null) {
            int i = 0;
            while (i < rules.size()) {
                list.addAll(((HighlightRule)rules.get(i)).validate(module, element));
                ++i;
            }
        }
        return list;
    }

    @Override
    public String getDisplayLabel(Module module, int level) {
        MetaDataDictionary meta = MetaDataDictionary.getInstance();
        IPredefinedStyle selector = meta.getPredefinedStyle(this.name);
        if (selector == null) {
            return super.getDisplayLabel(module, level);
        }
        List<IElementDefn> elementDefns = meta.getExtensions();
        ElementDefn elementDefn = null;
        int i = 0;
        while (i < elementDefns.size()) {
            ElementDefn tmpElementDefn = (ElementDefn)elementDefns.get(i);
            if (this.name.equalsIgnoreCase(tmpElementDefn.getSelector())) {
                elementDefn = tmpElementDefn;
                break;
            }
            ++i;
        }
        String displayLabel = null;
        if (elementDefn != null) {
            if (!(elementDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)elementDefn;
            IReportItemFactory reportItemFactory = extDefn.getReportItemFactory();
            if (reportItemFactory == null) {
                return super.getDisplayLabel(module, level);
            }
            IMessages msgs = reportItemFactory.getMessages();
            if (msgs == null) {
                return super.getDisplayLabel(module, level);
            }
            ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
            displayLabel = msgs.getMessage(selector.getDisplayNameKey(), locale);
        } else {
            displayLabel = ModelMessages.getMessage(selector.getDisplayNameKey());
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = super.getDisplayLabel(module, level);
        }
        return displayLabel;
    }
}

