/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.cache;

import java.util.logging.Logger;
import org.eclipse.birt.core.archive.cache.CacheList;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.cache.FileCacheManager;

public class SystemCacheManager {
    protected static Logger logger = Logger.getLogger(SystemCacheManager.class.getName());
    protected int maxCacheSize;
    protected int usedCacheSize;
    protected CacheList caches;
    protected boolean enableSystemCache;

    public SystemCacheManager() {
        this(0);
    }

    public SystemCacheManager(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.usedCacheSize = 0;
        this.caches = new CacheList();
    }

    public void setMaxCacheSize(int size) {
        this.maxCacheSize = size;
    }

    void increaseUsedCacheSize(int size) {
        this.usedCacheSize += size;
    }

    public int getUsedCacheSize() {
        return this.usedCacheSize;
    }

    void removeCaches(FileCacheManager manager) {
        Cacheable cache = this.caches.first();
        while (cache != null) {
            Cacheable next = cache.getNext();
            if (cache.manager == manager) {
                this.caches.remove(cache);
                manager.caches.remove(cache.getCacheKey());
                --this.usedCacheSize;
            }
            cache = next;
        }
    }

    void removeCache(Cacheable cache) {
        this.caches.remove(cache);
    }

    void addCaches(Cacheable[] caches) {
        if (this.maxCacheSize == 0) {
            Cacheable[] cacheableArray = caches;
            int n = caches.length;
            int n2 = 0;
            while (n2 < n) {
                Cacheable cache = cacheableArray[n2];
                cache.getReferenceCount().set(-2);
                cache.manager.caches.remove(cache.getCacheKey());
                ++n2;
            }
        } else {
            Cacheable[] cacheableArray = caches;
            int n = caches.length;
            int n3 = 0;
            while (n3 < n) {
                Cacheable cache = cacheableArray[n3];
                cache.getReferenceCount().set(-1);
                this.caches.add(cache);
                ++n3;
            }
            this.adjustSystemCaches();
        }
    }

    void addCache(Cacheable cache) {
        if (this.maxCacheSize == 0) {
            cache.getReferenceCount().set(-2);
            cache.manager.caches.remove(cache.getCacheKey());
        } else {
            cache.getReferenceCount().set(-1);
            this.caches.add(cache);
            this.adjustSystemCaches();
        }
    }

    private void adjustSystemCaches() {
        int releaseCacheSize = this.caches.size() - this.maxCacheSize;
        if (releaseCacheSize > 0) {
            int i = 0;
            while (i < releaseCacheSize) {
                Cacheable removed = this.caches.remove();
                if (removed.getReferenceCount().compareAndSet(-1, -2)) {
                    removed.manager.caches.remove(removed.getCacheKey());
                    --this.usedCacheSize;
                }
                ++i;
            }
        }
    }
}

