/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import fr.ifremer.isisfish.util.ssh.ProgressMonitor;
import fr.ifremer.isisfish.util.ssh.SSHException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSHUtils {
    private static Log log = LogFactory.getLog(SSHUtils.class);
    protected static final byte LINE_FEED = 10;
    protected static final int BUFFER_SIZE = 1024;
    protected static final int HUNDRED_KILOBYTES = 102400;

    protected SSHUtils() {
    }

    protected static void sendAck(OutputStream out) throws IOException {
        byte[] buf = new byte[]{0};
        out.write(buf);
        out.flush();
    }

    protected static void waitForAck(InputStream in) throws IOException, SSHException {
        int b = in.read();
        if (b == -1) {
            throw new SSHException("No response from server");
        }
        if (b != 0) {
            StringBuffer sb = new StringBuffer();
            int c = in.read();
            while (c > 0 && c != 10) {
                sb.append((char)c);
                c = in.read();
            }
            if (b == 1) {
                throw new SSHException("server indicated an error: " + sb.toString());
            }
            if (b == 2) {
                throw new SSHException("server indicated a fatal error: " + sb.toString());
            }
            throw new SSHException("unknown response, code " + b + " message: " + sb.toString());
        }
    }

    protected static int trackProgress(long filesize, long totalLength, int percentTransmitted) {
        int percent = (int)Math.round(Math.floor((double)totalLength / (double)filesize * 100.0));
        if (percent > percentTransmitted) {
            if (filesize < 0x100000L) {
                if (percent % 5 == 0) {
                    if (percent == 100) {
                        System.out.println(" 100%");
                    } else {
                        System.out.print("*");
                    }
                }
            } else if (percent == 50) {
                System.out.println(" 50%");
            } else if (percent == 100) {
                System.out.println(" 100%");
            } else {
                System.out.print(".");
            }
        }
        return percent;
    }

    public static int exec(Session session, String command) throws SSHException {
        return SSHUtils.exec(session, command, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int exec(Session session, String command, Writer out) throws SSHException {
        int exitStatus = 0;
        BufferedReader br = null;
        try {
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            br = new BufferedReader(new InputStreamReader(channel.getInputStream()));
            channel.connect();
            String line = null;
            while (true) {
                if ((line = br.readLine()) != null) {
                    if (out != null) {
                        out.write(line);
                        continue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Remote output : " + line));
                    continue;
                }
                if (channel.isClosed()) {
                    exitStatus = channel.getExitStatus();
                    if (!log.isInfoEnabled()) break;
                    log.info((Object)("JSch channel exit-status: " + exitStatus));
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            channel.disconnect();
        }
        catch (JSchException e) {
            try {
                throw new SSHException("I/O error while executing command", e);
                catch (IOException e2) {
                    throw new SSHException("I/O error while executing command", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)br);
        return exitStatus;
    }

    public static void scpFrom(Session session, String remoteFileName, File localFile) throws SSHException {
        SSHUtils.scpFrom(session, remoteFileName, localFile, null);
    }

    public static void scpFrom(Session session, String remoteFileName, File localFile, ProgressMonitor monitor) throws SSHException {
        String command = "scp -f -r \"" + remoteFileName + "\"";
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            SSHUtils.sendAck(out);
            SSHUtils.startRemoteCpProtocol(in, out, localFile, monitor);
        }
        catch (IOException e) {
            throw new SSHException(e);
        }
        catch (JSchException e) {
            throw new SSHException(e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public static void scpTo(Session session, File localFile, String remoteFilePath) throws SSHException {
        try {
            SSHUtils.doSingleTransfer(session, localFile, remoteFilePath);
        }
        catch (IOException e) {
            throw new SSHException(e);
        }
        catch (JSchException e) {
            throw new SSHException(e);
        }
    }

    protected static void startRemoteCpProtocol(InputStream in, OutputStream out, File localFile, ProgressMonitor monitor) throws IOException, SSHException {
        String serverResponse;
        File startFile = localFile;
        while (true) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            while (true) {
                int read;
                if ((read = in.read()) < 0) {
                    return;
                }
                if ((byte)read == 10) break;
                stream.write(read);
            }
            serverResponse = stream.toString("UTF-8");
            if (serverResponse.charAt(0) == 'C') {
                SSHUtils.parseAndFetchFile(serverResponse, startFile, out, in, monitor);
                continue;
            }
            if (serverResponse.charAt(0) == 'D') {
                startFile = SSHUtils.parseAndCreateDirectory(serverResponse, startFile);
                SSHUtils.sendAck(out);
                continue;
            }
            if (serverResponse.charAt(0) == 'E') {
                startFile = startFile.getParentFile();
                SSHUtils.sendAck(out);
                continue;
            }
            if (serverResponse.charAt(0) == '\u0001' || serverResponse.charAt(0) == '\u0002') break;
        }
        throw new IOException(serverResponse.substring(1));
    }

    protected static File parseAndCreateDirectory(String serverResponse, File localFile) {
        int start = serverResponse.indexOf(" ");
        start = serverResponse.indexOf(" ", start + 1);
        String directoryName = serverResponse.substring(start + 1);
        if (localFile.isDirectory()) {
            File dir = new File(localFile, directoryName);
            dir.mkdir();
            log.debug((Object)("Creating: " + dir));
            return dir;
        }
        return null;
    }

    protected static void parseAndFetchFile(String serverResponse, File localFile, OutputStream out, InputStream in, ProgressMonitor monitor) throws IOException, SSHException {
        int start = 0;
        int end = serverResponse.indexOf(" ", start + 1);
        start = end + 1;
        end = serverResponse.indexOf(" ", start + 1);
        long filesize = Long.parseLong(serverResponse.substring(start, end));
        String filename = serverResponse.substring(end + 1);
        log.debug((Object)("Receiving: " + filename + " : " + filesize));
        File transferFile = localFile.isDirectory() ? new File(localFile, filename) : localFile;
        SSHUtils.fetchFile(transferFile, filesize, out, in, monitor);
        SSHUtils.waitForAck(in);
        SSHUtils.sendAck(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fetchFile(File localFile, long filesize, OutputStream out, InputStream in, ProgressMonitor monitor) throws IOException {
        byte[] buf = new byte[1024];
        SSHUtils.sendAck(out);
        if (monitor != null) {
            monitor.init(filesize);
        }
        OutputStream fos = null;
        try {
            fos = new FileOutputStream(localFile);
            while (true) {
                int length;
                if ((length = in.read(buf, 0, 1024L < filesize ? 1024 : (int)filesize)) < 0) {
                    throw new EOFException("Unexpected end of stream.");
                }
                ((FileOutputStream)fos).write(buf, 0, length);
                if ((filesize -= (long)length) == 0L) {
                    break;
                }
                if (monitor == null) continue;
                monitor.count(length);
            }
        }
        finally {
            fos.flush();
            ((FileOutputStream)fos).close();
        }
        if (monitor != null) {
            monitor.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doSingleTransfer(Session session, File localFile, String remoteFilePath) throws IOException, JSchException, SSHException {
        String command = "scp -t \"" + remoteFilePath + "\"";
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setCommand(command);
        try {
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            SSHUtils.waitForAck(in);
            SSHUtils.sendFileToRemote(localFile, in, out);
        }
        finally {
            channel.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendFileToRemote(File localFile, InputStream in, OutputStream out) throws IOException, SSHException {
        long filesize = localFile.length();
        String command = "C0644 " + filesize + " ";
        command = command + localFile.getName();
        command = command + "\n";
        out.write(command.getBytes());
        out.flush();
        SSHUtils.waitForAck(in);
        byte[] buf = new byte[1024];
        try (FileInputStream fis = null;){
            int len;
            fis = new FileInputStream(localFile);
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            out.flush();
            SSHUtils.sendAck(out);
            SSHUtils.waitForAck(in);
        }
    }

    protected static ChannelSftp openSftpChannel(Session session) throws JSchException {
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        return channel;
    }

    public static void sftpFrom(Session session, File localFile, String remotePath) throws SSHException {
        ChannelSftp channel = null;
        try {
            channel = SSHUtils.openSftpChannel(session);
            channel.connect();
            try {
                SftpATTRS attrs = channel.stat(remotePath);
                if (attrs.isDir() && !remotePath.endsWith("/")) {
                    remotePath = remotePath + "/";
                }
            }
            catch (SftpException attrs) {
                // empty catch block
            }
            SSHUtils.getDir(channel, remotePath, localFile);
        }
        catch (SftpException e) {
            throw new SSHException(e);
        }
        catch (JSchException e) {
            throw new SSHException(e);
        }
        catch (IOException e) {
            throw new SSHException(e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    protected static void getDir(ChannelSftp channel, String remoteFile, File localFile) throws IOException, SftpException {
        String pwd = remoteFile;
        if (remoteFile.lastIndexOf(47) != -1 && remoteFile.length() > 1) {
            pwd = remoteFile.substring(0, remoteFile.lastIndexOf(47));
        }
        channel.cd(pwd);
        if (!localFile.exists()) {
            localFile.mkdirs();
        }
        Vector files = channel.ls(remoteFile);
        for (int i = 0; i < files.size(); ++i) {
            ChannelSftp.LsEntry le = (ChannelSftp.LsEntry)files.elementAt(i);
            String name = le.getFilename();
            if (le.getAttrs().isDir()) {
                if (name.equals(".") || name.equals("..")) continue;
                SSHUtils.getDir(channel, channel.pwd() + "/" + name + "/", new File(localFile, le.getFilename()));
                continue;
            }
            SSHUtils.getFile(channel, le, localFile);
        }
        channel.cd("..");
    }

    protected static void getFile(ChannelSftp channel, ChannelSftp.LsEntry le, File localFile) throws IOException, SftpException {
        boolean trackProgress;
        String remoteFile = le.getFilename();
        if (!localFile.exists()) {
            String path = localFile.getAbsolutePath();
            int i = 0;
            i = path.lastIndexOf(File.pathSeparator);
            if (i != -1 && path.length() > File.pathSeparator.length()) {
                new File(path.substring(0, i)).mkdirs();
            }
        }
        if (localFile.isDirectory()) {
            localFile = new File(localFile, remoteFile);
        }
        long totalLength = le.getAttrs().getSize();
        UtilsProgressMonitor monitor = null;
        boolean bl = trackProgress = totalLength > 102400L;
        if (trackProgress) {
            monitor = new UtilsProgressMonitor();
        }
        channel.get(remoteFile, localFile.getAbsolutePath(), (SftpProgressMonitor)monitor);
    }

    public static void sftpTo(Session session, File localFile, String remoteFilePath) throws SSHException {
        try {
            SSHUtils.doSingleSftpransfer(session, localFile, remoteFilePath);
        }
        catch (IOException e) {
            throw new SSHException(e);
        }
        catch (JSchException e) {
            throw new SSHException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doSingleSftpransfer(Session session, File localFile, String remoteFilePath) throws IOException, JSchException {
        ChannelSftp channel = SSHUtils.openSftpChannel(session);
        try {
            channel.connect();
            try {
                SSHUtils.sendFileToRemote(channel, localFile, remoteFilePath);
            }
            catch (SftpException e) {
                throw new JSchException(e.toString());
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    protected static void sendFileToRemote(ChannelSftp channel, File localFile, String remotePath) throws IOException, SftpException {
        long filesize = localFile.length();
        if (remotePath == null) {
            remotePath = localFile.getName();
        }
        boolean trackProgress = filesize > 102400L;
        UtilsProgressMonitor monitor = null;
        if (trackProgress) {
            monitor = new UtilsProgressMonitor();
        }
        channel.put(localFile.getAbsolutePath(), remotePath, (SftpProgressMonitor)monitor);
    }

    protected static class UtilsProgressMonitor
    implements SftpProgressMonitor {
        private long initFileSize = 0L;
        private long totalLength = 0L;
        private int percentTransmitted = 0;

        protected UtilsProgressMonitor() {
        }

        public void init(int op, String src, String dest, long max) {
            this.initFileSize = max;
            this.totalLength = 0L;
            this.percentTransmitted = 0;
        }

        public boolean count(long len) {
            this.totalLength += len;
            this.percentTransmitted = SSHUtils.trackProgress(this.initFileSize, this.totalLength, this.percentTransmitted);
            return true;
        }

        public void end() {
        }

        public long getTotalLength() {
            return this.totalLength;
        }
    }
}

