/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.population.PopulationBasicsUI;
import fr.ifremer.isisfish.ui.input.population.WizardGroupCreationUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class PopulationBasicsHandler
extends InputContentHandler<PopulationBasicsUI> {
    private static final Log log = LogFactory.getLog(PopulationBasicsHandler.class);
    protected boolean init;

    protected PopulationBasicsHandler(PopulationBasicsUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationBasicsUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PopulationBasicsHandler.this.init = true;
                if (evt.getNewValue() == null) {
                    ((PopulationBasicsUI)((PopulationBasicsHandler)PopulationBasicsHandler.this).inputContentUI).fieldPopulationBasicsName.setText("");
                    ((PopulationBasicsUI)((PopulationBasicsHandler)PopulationBasicsHandler.this).inputContentUI).fieldPopulationBasicsGeographicID.setText("");
                    ((PopulationBasicsUI)((PopulationBasicsHandler)PopulationBasicsHandler.this).inputContentUI).fieldPopulationBasicsNbClasses.setText("");
                    ((PopulationBasicsUI)((PopulationBasicsHandler)PopulationBasicsHandler.this).inputContentUI).fieldPopulationBasicsComment.setText("");
                    ((PopulationBasicsUI)((PopulationBasicsHandler)PopulationBasicsHandler.this).inputContentUI).tableAgeLength.setModel(new DefaultTableModel());
                }
                if (evt.getNewValue() != null) {
                    PopulationBasicsHandler.this.setTableAgeLengthModel();
                }
                PopulationBasicsHandler.this.init = false;
            }
        });
    }

    public void refresh() {
        Population population = ((PopulationBasicsUI)this.inputContentUI).getSaveVerifier().getEntity(Population.class);
        ((PopulationBasicsUI)this.inputContentUI).setBean((Population)null);
        ((PopulationBasicsUI)this.inputContentUI).setBean(population);
        if (((PopulationBasicsUI)this.inputContentUI).getBean() != null) {
            this.setTableAgeLengthModel();
        }
    }

    protected void createGroups() {
        int response = JOptionPane.showConfirmDialog(this.inputContentUI, I18n.t((String)"isisfish.populationBasics.confirmCreateGroups", (Object[])new Object[0]), I18n.t((String)"isisfish.common.confirm", (Object[])new Object[0]), 0, 2);
        if (response == 0) {
            JFrame wizardFrame = new JFrame();
            wizardFrame.setLayout(new BorderLayout());
            WizardGroupCreationUI wizard = new WizardGroupCreationUI((JAXXContext)this.inputContentUI);
            wizard.getHandler().initParent((PopulationBasicsUI)this.inputContentUI);
            wizardFrame.add((Component)wizard, "Center");
            wizardFrame.setTitle(I18n.t((String)"isisfish.wizardGroupCreation.title", (Object[])new Object[0]));
            Species species = ((PopulationBasicsUI)this.inputContentUI).getBean().getSpecies();
            wizard.getHandler().setAgeType(species.isAgeGroupType());
            if (wizard.getHandler().isAgeType()) {
                wizard.getHandler().setCard("singleGroupAge");
            } else {
                wizard.getHandler().setCard("beginGroupLength");
            }
            wizardFrame.pack();
            wizardFrame.setLocationRelativeTo(this.inputContentUI);
            wizardFrame.setVisible(true);
        }
    }

    protected void setTableAgeLengthModel() {
        List<PopulationGroup> popGroup = ((PopulationBasicsUI)this.inputContentUI).getBean().getPopulationGroup();
        if (popGroup != null) {
            DefaultTableModel model = new DefaultTableModel(2, popGroup.size() + 1);
            model.setValueAt("Age", 0, 0);
            model.setValueAt("Lengths", 1, 0);
            int cnt = 1;
            for (PopulationGroup pg : popGroup) {
                model.setValueAt(pg.getAge(), 0, cnt);
                model.setValueAt(pg.getLength(), 1, cnt);
                ++cnt;
            }
            ((PopulationBasicsUI)this.inputContentUI).tableAgeLength.setModel(model);
        }
    }

    protected void create() {
        InputUI inputUI = ((PopulationBasicsUI)this.inputContentUI).getContextValue(InputUI.class, "parent");
        Species species = inputUI.getHandler().findSpecies();
        Population population = this.createPopulation(((PopulationBasicsUI)this.inputContentUI).getTopiaContext(), species);
        inputUI.getHandler().insertTreeNode(Population.class, population);
        ((PopulationBasicsUI)this.inputContentUI).setInfoText(I18n.t((String)"isisfish.message.creation.finished", (Object[])new Object[0]));
    }

    protected Population createPopulation(TopiaContext context, Species species) {
        Population pop = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"createPopulation called");
        }
        try {
            String name = "Population_new";
            PopulationDAO dao = IsisFishDAOHelper.getPopulationDAO(context);
            pop = (Population)dao.create(new Object[0]);
            pop.setName(name);
            species.addPopulation(pop);
            pop.setSpecies(species);
            species.update();
            pop.update();
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Population"}), eee);
        }
        return pop;
    }
}

