/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.DataStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.ResultDatabaseStorage;
import fr.ifremer.isisfish.datastore.ResultMappedStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.ResultStorageCSV;
import fr.ifremer.isisfish.datastore.ResultStorageInMemory;
import fr.ifremer.isisfish.datastore.SimulationInformation;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionDAO;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;
import org.nuiton.util.version.Versions;

public class SimulationStorage
extends DataStorage {
    public static final String SIMULATION_PATH = "simulations";
    public static final String INFORMATION_FILENAME = "information";
    public static final String OBJECTIVE_FILENAME = "objective";
    public static final String CONTROL_FILENAME = "control";
    public static final String PARAMETERS_FILENAME = "parameters.properties";
    public static final String RESULT_XML_FILENAME = "isis-mexico-output.xml";
    public static final String RESULT_FILENAME = "results.mapped";
    public static final String RESULT_DIRECTORY = "results";
    public static final String RESULT_EXPORT_DIRECTORY = "resultExports";
    public static final String DESIGN_PLAN_FILENAME = "isis-mexico-designplan.xml";
    public static final String SENSITIVITY_RESULTS = "sensitivityresults";
    private static Log log = LogFactory.getLog(SimulationStorage.class);
    protected static Map<String, SimulationStorage> simulations = new ReferenceMap();
    protected SimulationInformation information = null;
    protected SimulationParameter parameter = null;
    protected transient ResultStorage resultStorage = null;
    public static String LOG_CATEGORY = "fr.ifremer.isisfish.simulator";
    protected boolean useLog;
    protected transient File simulationControlFile = null;
    protected transient Double objective = null;

    protected SimulationStorage(File directory, String name, SimulationParameter parameter) {
        super(directory, name);
        this.setParameter(parameter);
    }

    @Override
    public void closeStorage() throws TopiaException {
        if (this.resultStorage != null) {
            this.resultStorage.close();
            this.resultStorage = null;
        }
        super.closeStorage();
    }

    public static File getSimulationDirectory() {
        File result = IsisFish.config.getDatabaseDirectory();
        if (!(result = new File(result, SIMULATION_PATH)).exists()) {
            result.mkdirs();
        }
        return result;
    }

    public static File getSimulationDirectory(String name) {
        File result = SimulationStorage.getSimulationDirectory();
        if (!(result = new File(result, name)).exists()) {
            result.mkdirs();
        }
        return result;
    }

    public static File getSensitivityResultsDirectory() {
        File result = IsisFish.config.getDatabaseDirectory();
        if (!(result = new File(result, SENSITIVITY_RESULTS)).exists()) {
            result.mkdirs();
        }
        return result;
    }

    public static File getResultExportDirectory(File root) {
        File result = new File(root, RESULT_EXPORT_DIRECTORY);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public static File getSimulationParametersFile(File root) {
        File result = new File(root, PARAMETERS_FILENAME);
        return result;
    }

    public static File getSimulationInformationFile(File root) {
        File result = new File(root, INFORMATION_FILENAME);
        return result;
    }

    public static File getSimulationObjectiveFile(File root) {
        File result = new File(root, OBJECTIVE_FILENAME);
        return result;
    }

    public Double getObjective() throws IOException {
        if (this.objective == null) {
            File ObjFile = this.getObjectiveFile();
            if (this.file.exists()) {
                String s = FileUtils.readFileToString((File)ObjFile);
                this.objective = Double.parseDouble(s);
            }
        }
        return this.objective;
    }

    public void setObjective(double d) throws IOException {
        this.objective = d;
        FileUtils.writeStringToFile((File)this.getObjectiveFile(), (String)String.valueOf(d));
    }

    public static File getSimulationResultXmlFile(File root) {
        File result = new File(root, RESULT_XML_FILENAME);
        return result;
    }

    public static File getResultFile(File root) {
        File result = new File(root, RESULT_FILENAME);
        return result;
    }

    public static File getResultDirectory(File root) {
        File result = new File(root, RESULT_DIRECTORY);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    protected File getSimulationParametersFile() {
        File result = SimulationStorage.getSimulationParametersFile(this.getDirectory());
        return result;
    }

    public static File getMexicoDesignPlan(File root) {
        File result = new File(root, DESIGN_PLAN_FILENAME);
        return result;
    }

    protected File getSimulationControlFile() {
        if (this.simulationControlFile == null) {
            this.simulationControlFile = new File(this.getDirectory(), CONTROL_FILENAME);
        }
        return this.simulationControlFile;
    }

    public static File getSimulationControlFile(String id) {
        File result = new File(SimulationStorage.getSimulationDirectory(id), CONTROL_FILENAME);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveControl(SimulationControl control) {
        FileOutputStream out = null;
        try {
            Properties prop = control.getProperties();
            File file = this.getSimulationControlFile();
            out = new FileOutputStream(file);
            prop.store(out, "Control");
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (Exception eee) {
            log.warn((Object)"Can't save control", (Throwable)eee);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void readControl(String id, SimulationControl control, String ... exclude) {
        File file = SimulationStorage.getSimulationControlFile(id);
        SimulationStorage.readControl(file, control, exclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readControl(File controlFile, SimulationControl control, String ... exclude) {
        block6: {
            try {
                block7: {
                    Properties prop = new Properties();
                    if (!controlFile.exists()) break block7;
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(controlFile);
                        prop.load(in);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    for (String e : exclude) {
                        prop.remove(e);
                    }
                    control.updateFromProperties(prop);
                    break block6;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Control file '" + controlFile.getAbsolutePath() + "' doesn't exists"));
                }
            }
            catch (Exception e) {
                log.warn((Object)"Can't read control", (Throwable)e);
            }
        }
    }

    public void setParameter(SimulationParameter parameter) {
        this.parameter = parameter;
        if (parameter != null) {
            Properties prop = parameter.toProperties();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Store params: " + prop));
            }
            File file = this.getSimulationParametersFile();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                prop.store(out, "Parameters");
            }
            catch (IOException eee) {
                try {
                    throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.save.simulation.parameters", (Object[])new Object[]{file}), eee);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public SimulationParameter getParameter() {
        if (this.parameter == null) {
            Properties prop = new Properties();
            File file = this.getSimulationParametersFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading properties from : " + file.getAbsolutePath()));
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                prop.load(in);
                this.parameter = new SimulationParameterImpl();
                this.parameter.fromProperties(prop);
            }
            catch (IOException eee) {
                try {
                    throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.read.simulation.parameters", (Object[])new Object[]{file}), eee);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return this.parameter;
    }

    public SimulationParameter getForceReloadParameter() {
        if (this.parameter != null) {
            this.setParameter(this.parameter);
        }
        Properties prop = new Properties();
        File file = this.getSimulationParametersFile();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            prop.load(in);
            this.parameter = new SimulationParameterImpl();
            this.parameter.fromProperties(prop);
        }
        catch (IOException eee) {
            try {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.read.simulation.parameters", (Object[])new Object[]{file}), eee);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return this.parameter;
    }

    protected File getInformationFile() {
        File result = new File(this.getDirectory(), INFORMATION_FILENAME);
        return result;
    }

    protected File getObjectiveFile() {
        File result = new File(this.getDirectory(), OBJECTIVE_FILENAME);
        return result;
    }

    public SimulationInformation getInformation() {
        if (this.information == null) {
            this.information = new SimulationInformation(this.getInformationFile());
        }
        return this.information;
    }

    public ResultStorage getResultStorage() throws StorageException {
        if (this.resultStorage == null) {
            SimulationParameter param = this.getParameter();
            String isisFishVersion = param.getIsisFishVersion();
            if (Versions.smallerThan((String)isisFishVersion, (String)"4.2.0.0")) {
                this.resultStorage = new ResultDatabaseStorage(this);
            } else {
                String maxTimeStep = param.getTagValue().get("ResultStorageInMemory.maxTimeStep");
                if (maxTimeStep != null) {
                    this.resultStorage = new ResultStorageInMemory(this);
                } else {
                    try {
                        this.resultStorage = SimulationStorage.getResultFile(this.getDirectory()).exists() ? new ResultMappedStorage(this) : new ResultStorageCSV(this);
                    }
                    catch (IOException ex) {
                        throw new StorageException("Can't get storage", ex);
                    }
                }
            }
        }
        return this.resultStorage;
    }

    public static boolean exists(String name) {
        boolean result = SimulationStorage.getSimulationNames().contains(name);
        result = result || SimulationStorage.getRemoteSimulationNames().contains(name);
        return result;
    }

    public static boolean localyExists(String name) {
        return SimulationStorage.getSimulationNames().contains(name);
    }

    public static SimulationStorage getSimulation(String name) {
        SimulationStorage result = simulations.get(name);
        if (result == null) {
            File directory = SimulationStorage.getSimulationDirectory(name);
            log.info((Object)("Try to open simulation " + name + "(" + directory + ")"));
            if (directory.exists()) {
                result = new SimulationStorage(directory, name, null);
                simulations.put(name, result);
            }
        }
        return result;
    }

    public static SimulationStorage create(String name, SimulationParameter parameter) throws StorageException {
        if (SimulationStorage.localyExists(name)) {
            throw new IllegalArgumentException("Can't create simulation this simulation name exists: " + name);
        }
        File directory = SimulationStorage.getSimulationDirectory(name);
        SimulationStorage result = new SimulationStorage(directory, name, parameter);
        simulations.put(name, result);
        return result;
    }

    public static List<String> getSimulationNames() {
        File dir = SimulationStorage.getSimulationDirectory();
        return SimulationStorage.getStorageNames(dir);
    }

    public static List<String> getNewSimulationNames() {
        List<String> result = SimulationStorage.getSimulationNames();
        result.removeAll(SimulationStorage.getRemoteSimulationNames());
        return result;
    }

    public static List<String> getRemoteSimulationNames() {
        File dir = SimulationStorage.getSimulationDirectory();
        return SimulationStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteSimulationNames() {
        List<String> result = SimulationStorage.getRemoteSimulationNames();
        result.removeAll(SimulationStorage.getSimulationNames());
        return result;
    }

    public static FisheryRegion getFisheryRegion(TopiaContext context) throws StorageException {
        FisheryRegion result;
        try {
            FisheryRegionDAO regionDAO = IsisFishDAOHelper.getFisheryRegionDAO(context);
            List regions = regionDAO.findAll();
            if (regions.size() != 1) {
                throw new StorageException("Invalide region database number of region must be 1 not " + regions.size());
            }
            result = (FisheryRegion)regions.get(0);
        }
        catch (TopiaException eee) {
            throw new StorageException("Can't find FisheryRegion in this Region", eee);
        }
        return result;
    }

    public static void checkout(String name) throws VCSException, TopiaException {
        SimulationStorage.checkout(IsisFish.config.getDatabaseDirectory(), "simulations/" + name);
        SimulationStorage sim = SimulationStorage.getSimulation(name);
        File file = sim.getDataBackupFile();
        TopiaContext tx = sim.getStorage().beginTransaction();
        tx.restore(file);
        tx.commitTransaction();
        tx.closeContext();
    }

    @Override
    public void rename(String toName) throws StorageException {
        simulations.remove(this.getName());
        super.rename(toName);
        simulations.put(toName, this);
    }

    public static SimulationStorage importZip(File file) throws IOException, TopiaException {
        return SimulationStorage.importAndRenameZip(file, null);
    }

    public static SimulationStorage importAndRenameZip(File file, String newName) throws IOException, TopiaException {
        SimulationStorage result = SimulationStorage.importAndRenameZip(SimulationStorage.getSimulationDirectory(), file, newName);
        simulations.put(result.getName(), result);
        return result;
    }

    public static SimulationStorage importAndRenameZip(File directory, File file, String newName) throws IOException, TopiaException {
        File simDir;
        SimulationStorage result;
        File data;
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(I18n.t((String)"directory %s must be a directory", (Object[])new Object[]{directory.getAbsolutePath()}));
        }
        String renameFrom = null;
        String renameTo = null;
        if (newName != null) {
            renameFrom = "^.*?/(.*)$";
            renameTo = newName + "/$1";
        }
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"Import simulation file %s in directory %s and rename from %s to %s", (Object[])new Object[]{file, directory, renameFrom, renameTo}));
        }
        String lastEntry = ZipUtil.uncompressAndRename((File)file, (File)directory, (String)renameFrom, renameTo);
        String name = lastEntry.substring(0, lastEntry.indexOf("/"));
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"Last entry was %s extract name %s", (Object[])new Object[]{lastEntry, name}));
        }
        if ((data = (result = new SimulationStorage(simDir = new File(directory, name), name, null)).getDataBackupFile()).exists()) {
            TopiaContext tx = result.getStorage().beginTransaction();
            tx.restore(data);
            tx.commitTransaction();
            result.closeStorage();
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractRegion(String regionName) throws StorageException {
        File tmpDir = null;
        try {
            TopiaContext tx = this.getStorage().beginTransaction();
            String oldRegionName = SimulationStorage.getFisheryRegion(tx).getName();
            tmpDir = FileUtil.createTempDirectory((String)"extractRegionFromSimulation", (String)"");
            ArrayList<File> forZip = new ArrayList<File>(2);
            File file1 = new File(tmpDir, oldRegionName);
            forZip.add(file1);
            file1 = new File(file1, "data-backup.sql.gz");
            forZip.add(file1);
            if (!file1.exists()) {
                this.prepare();
            }
            FileUtils.copyFile((File)this.getDataBackupFile(), (File)file1);
            File zipRegion = new File(tmpDir, "extractedRegion.zip");
            ZipUtil.compressFiles((File)zipRegion, (File)tmpDir, forZip);
            RegionStorage.importAndRenameZip(zipRegion, regionName);
            tx.commitTransaction();
            tx.closeContext();
            if (tmpDir == null) return;
        }
        catch (IOException ex) {
            try {
                throw new StorageException("Can't extract region", ex);
                catch (TopiaException ex2) {
                    throw new StorageException("Can't extract region", ex2);
                }
            }
            catch (Throwable throwable) {
                if (tmpDir == null) throw throwable;
                if (FileUtils.deleteQuietly(tmpDir)) throw throwable;
                log.warn((Object)I18n.t((String)"isisfish.error.delete.file", (Object[])new Object[]{tmpDir}));
                throw throwable;
            }
        }
        if (FileUtils.deleteQuietly((File)tmpDir)) return;
        log.warn((Object)I18n.t((String)"isisfish.error.delete.file", (Object[])new Object[]{tmpDir}));
    }

    public String getSimulationLogFile() {
        File root = SimulationStorage.getSimulationDirectory(this.name);
        return root + File.separator + "simulation.log";
    }

    @Override
    public File createZip(File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Save simulation parameters");
        }
        this.setParameter(this.parameter);
        return super.createZip(file);
    }

    @Override
    protected boolean isVersionnableFile(File file) {
        String filename = file.getName();
        boolean result = !".svn".equals(filename) && !"CVS".equals(filename) && !filename.endsWith("~");
        return result &= !new File(this.getFile(), "data").equals(file);
    }
}

